% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.hal9001}
\alias{summary.hal9001}
\title{Summary of HAL fits}
\usage{
\method{summary}{hal9001}(
  object,
  lambda = NULL,
  only_nonzero_coefs = TRUE,
  remove_redundant_duplicates = TRUE,
  round_cutoffs = 4,
  ...
)
}
\arguments{
\item{object}{An object of class \code{hal9001}, containing the results of
fitting the Highly Adaptive Lasso, as produced by \code{\link{fit_hal}}.}

\item{lambda}{Optional \code{numeric} value of the lambda tuning
parameter, for which corresponding coefficient values to be summarized.
Defaults to CV-optimal value \code{lambda_star}, or the minimum value of
\code{lambda_star}.}

\item{only_nonzero_coefs}{A \code{logical} specifying whether the summary
should include only non-zero coefficients.}

\item{remove_redundant_duplicates}{A \code{logical} specifying whether the
summary should remove redundant indicator basis function duplicates. If
basis functions are duplicated, then one coefficient will correspond to all
of the duplicates. If \code{remove_redundant_duplicates} is \code{TRUE},
then the shorter basis function is retained. For example, the same
coefficient may correspond to terms "I(age >= 50)*I(bmi >= 18)",
"I(age >= 50)", and "I(education >= 16)", which means these basis functions
all yield the same result. When \code{remove_redundant_duplicates} is
\code{TRUE}, the second basis function is omitted due to the duplicated
term "I(age >= 50)".}

\item{round_cutoffs}{An \code{integer} indicating the number of decimal
places to be used for rounding term cutoff values.}

\item{...}{Additional arguments passed to \code{summary} as necessary.}
}
\value{
A list summarizing a \code{hal9001} object's coefficients.
}
\description{
Summary of HAL fits
}
\details{
Method for summarizing the coefficients of the Highly Adaptive
 Lasso estimator in terms of the basis functions corresponding to covariates
 and interactions of covariates, returned as a single S3 object of class
 \code{hal9001}.
}
