% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.nlsfit.R
\name{bootstrap.nlsfit}
\alias{bootstrap.nlsfit}
\title{Bootstrap a non-linear least-squares fit}
\usage{
bootstrap.nlsfit(fn, par.guess, y, x, bsamples, priors = list(param = c(), p
  = c(), psamples = c()), ..., lower = rep(x = -Inf, times =
  length(par.guess)), upper = rep(x = +Inf, times = length(par.guess)), dy,
  dx, CovMatrix, gr, dfn, mask, use.minpack.lm = TRUE, parallel = FALSE,
  error = sd, cov_fn = cov, maxiter = 500, success.infos = 1:3,
  relative.weights = FALSE, na.rm = FALSE)
}
\arguments{
\item{fn}{\code{fn(par, x, ...)}. The (non-linear) function to be fitted to the
data. Its first argument must be the fit parameters named \code{par}. The
second must be \code{x}, the explaining variable. Additional parameters
might be passed to the function. Currently we pass \code{boot.r} which is \code{0}
for the original data and the ID (1, ...) of the bootstrap sample otherwise.
As more parameters might be added in the future it is recommended that the
fit function accepts \code{...} as the last parameter to be forward compatible.}

\item{par.guess}{initial guess values for the fit parameters.}

\item{y}{the data as a one-dimensional numerical vector to be described by
the fit function.}

\item{x}{values of the explaining variable in form of a one-dimensional
numerical vector.}

\item{bsamples}{bootstrap samples of \code{y} (and \code{x}, if applicable).
Must be provided as array of dimensions \code{c(boot.R, n)} with \code{n}
equals to \code{length(y)} in case of 'yerrors' and For 'xyerrors' to
\code{length(y) + length(x)}.}

\item{priors}{List possessing the elements \code{param}, \code{p} and \code{psamples}.
The vector \code{param} includes the indices of all fit parameters that are
to be constrained and the vector \code{p} the corresponding paramater values
(e.g. known from a previous fit). The list element \code{psamples} is a matrix of
dimensions \code{(boot.R, length(param))} and contains the corresponding
bootstrap samples. If this list is not specified priors are omitted
within the fit.}

\item{...}{Additional parameters passed to \code{fn}, \code{gr} and \code{dfn}.}

\item{lower}{Numeric vector of length \code{length(par.guess)}
of lower bounds on the fit parameters. If missing, \code{-Inf}
will be set for all.}

\item{upper}{Numeric vector of length \code{length(par.guess)}
of upper bounds on the fit parameters. If missing, \code{+Inf}
will be set for all.}

\item{dy, dx}{Numeric vector. Errors of the dependent and independent
variable, respectively. These do not need to be specified as they can be
computed from the bootstrap samples. In the case of parametric bootstrap it
might would lead to a loss of information if they were computed from the
pseudo-bootstrap samples. They must not be specified if a covariance matrix
is given.}

\item{CovMatrix}{complete variance-covariance matrix of dimensions
\code{c(length(y), length(y))} or \code{c(length(y)+length(x),
length(y)+length(x))} depending on the errormodel. Pass \code{NULL} if the matrix
has to be calculated from the \code{bsamples}. In that case, if the number of
boostrap samples is small compared to the number of variables, singular value
decomposition with small eigenvalue replacement will be used (see \link{invertCovMatrix})
to attempt a clean inversion.
In case a variance-covariance matrix is passed, the inversion will simply be attempted
using \code{solve} on the Cholesky decomposition.
Finally, if \code{CovMatrix} is missing, an uncorrelated fit will be performed.}

\item{gr}{\code{gr(par, x, ...)}. \code{gr=d(fn) / d(par)} is a function to
return the gradient of \code{fn}. It must return an array with
\code{length(x)} rows and \code{length(par)} columns.}

\item{dfn}{\code{dfn(par, x, ...)}. \code{dfn=d(fn) / dx} is the canonical
derivative of \code{fn} by \code{x} and only relevant if x-errors are
provided.}

\item{mask}{logical or integer index vector. The mask is applied to select the observations from the data that are to be used in the fit. It is applied to \code{x}, \code{y}, \code{dx}, \code{dy}, \code{bsamples} and \code{CovMatrix} as applicable.}

\item{use.minpack.lm}{use the \code{minpack.lm} library if available. This
is usually faster than the default \code{optim} but somtimes also less
stable.}

\item{parallel}{parallelise over bootstrap samples. The package
\code{parallel} is required.}

\item{error}{Function that takes a sample vector and returns the error
estimate. This is a parameter in order to support different resampling
methods like jackknife.}

\item{cov_fn}{function. Function to compute the covariance
(matrix). Default is \link{cov}.}

\item{maxiter}{integer. Maximum number of iterations that can be used in the
optimization process.}

\item{success.infos}{integer vector. When using \code{minpack.lm} there is the
\code{info} in the return value. Values of 1, 2 or 3 are certain success. A value
of 4 could either be a success or a saddle point. If you want to interpret
this as a success as well just pass \code{1:4} instead of the default \code{1:3}.}

\item{relative.weights}{are the errors on y (and x) to be interpreted as
relative weights instead of absolute ones? If TRUE, the covariance martix
of the fit parameter results is multiplied by chi^2/dof. This is the default
in many fit programs, e.g. gnuplot.}

\item{na.rm}{logical. If set to \code{true}, NAs in \code{y} and \code{dy} will be ignored.
If x-errors are taken into account, NAs in \code{x} and \code{dx} will be ignored, too.}
}
\value{
returns a list of class 'bootstrapfit'. It returns all input
parameters and adds in addition the following:
\item{t0}{the one dimensional numerical vector of length
\code{npar+1}. \code{npar} is the number of fit parameters. In case
of 'yerrors' this equals \code{length(par.guess)}. For 'xyerrors'
this equals \code{length(par.guess) + length(x)}. \code{t0} contains
the best fit parameters
obtained on the original data. The last element in \code{t0} is the
chisquare value.}
\item{t}{an array of dimensions \code{(npar+1, boot.R)} with
\code{npar} as in \code{t0}. The rows contain the individual
bootstrap observations.}
\item{bsamples}{the bootstrap samples used as an array of dimensions
\code{(length(y), boot.R)} or \code{(length(y)+length(x), boot.R)}
depending on the error model with \code{npar} as in \code{t0}. }
\item{Qval}{the p-value of the fit on the original data}
\item{chisqr}{the residual chisqr value.}
\item{dof}{the residual degrees of freedom of the fit.}
\item{nx}{the number of x-values.}
\item{tofn}{
the original \code{...} list of parameters to be passed on to the
fit function}
\item{mask}{original \code{mask} value}
}
\description{
Performs and bootstraps a non-linear least-squares fit to data with y and x
errors.
}
\examples{
## Declare some data.
value <- c(0.1, 0.2, 0.31)
dvalue <- c(0.01, 0.01, 0.015)
x <- c(1, 2, 3)
dx <- c(0.1, 0.1, 0.1)
boot.R <- 1500

fn <- function (par, x, boot.r, ...) par[1] + par[2] * x

## Before we can use the fit with this data, we need to create bootstrap
## samples. We do not want to use the correlation matrix here. Note that you
## can simply use the parametric.nlsfit function as a convenient wrapper of
## the two steps.
bsamples <- parametric.bootstrap(boot.R, c(value, x), c(dvalue, dx))
head(bsamples)

fit.result <- bootstrap.nlsfit(fn, c(1, 1), value, x, bsamples)
summary(fit.result)
plot(fit.result)

}
\seealso{
Other NLS fit functions: 
\code{\link{parametric.bootstrap.cov}()},
\code{\link{parametric.bootstrap}()},
\code{\link{parametric.nlsfit.cov}()},
\code{\link{parametric.nlsfit}()},
\code{\link{plot.bootstrapfit}()},
\code{\link{print.bootstrapfit}()},
\code{\link{simple.nlsfit}()},
\code{\link{summary.bootstrapfit}()}
}
\concept{NLS fit functions}
