% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{get_latest_ask_stories}
\alias{get_latest_ask_stories}
\title{Hacker News latest ask stories}
\usage{
get_latest_ask_stories(max_items = NULL)
}
\arguments{
\item{max_items}{Maximum number of items to retrieve.
If max_items = NULL, returns all available}
}
\value{
list of latest ask HN stories ids
}
\description{
Retrieves latest ask stories using Hacker News API
}
\details{
Parallel api requests can be enabled by running
\code{future::plan(future::multiprocess)}
}
\examples{
# get the lastest ask story on Hacker News
latest_ask_story <- get_latest_ask_stories(max_items = 1)
latest_ask_story

\donttest{
# get 10 latest ask stories on Hacker News
latest_10_ask_stories <- get_latest_ask_stories(max_items = 10)
latest_10_ask_stories

# get all latest ask stories on Hacker News
latest_ask_stories <- get_latest_ask_stories()
latest_ask_stories
}
}
