% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dem_crop.R
\name{dem_crop}
\alias{dem_crop}
\title{Crop DEM around points}
\usage{
dem_crop(data, x0, y0, L, plot = FALSE)
}
\arguments{
\item{data}{A DEM in RasterLayer format.}

\item{x0}{A value or vector of central x coordinate(s).}

\item{y0}{A value or vector of central y coordinate(s).}

\item{L}{Size of squares to cropped from the DEM.}

\item{plot}{Logical. Plot the DEM and the cropped sections?}
}
\value{
A cropped RasterLayer or list of RasterLayers.
}
\description{
A function for sampling a DEM by cropping squares of a given size around xy coordinates.
}
\examples{
# around one point
dem_cropped <- dem_crop(horseshoe, -468, 1266, L = 2)
raster::plot(dem_cropped)
points(-468, 1266)

# around multiple points
points <- data.frame(x = c(-467, -465, -466), y = c(1270, 1265, 1268))
dem_list <- dem_crop(horseshoe, points$x, points$y, L = 1, plot = TRUE)

# plot the first element
raster::plot(dem_list[[1]])
}
