% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhat.R
\name{rhat}
\alias{rhat}
\title{Function for extracting Rhat values from an hBayesDM object}
\usage{
rhat(fit = NULL, less = NULL)
}
\arguments{
\item{fit}{Model output of class \code{hBayesDM}}

\item{less}{A numeric value specifying how to check Rhat values. Defaults to FALSE.}
}
\value{
If \code{'less'} is specified, then \code{rhat(fit, less)} will return \code{TRUE} if all Rhat values are
less than or equal to \code{'less'}. If any values are greater than \code{'less'}, \code{rhat(fit, less)} will 
return \code{FALSE}. If \code{'less'} is left unspecified (NULL), \code{rhat(fit)} will return a \code{data.frame} object 
containing all Rhat values.
}
\description{
A convenience function for extracting Rhat values from an hBayesDM object. Can also 
check if all Rhat values are less than or equal to a specified value.
}
