% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{row_to_tree_assignment.H2OModel}
\alias{row_to_tree_assignment.H2OModel}
\alias{h2o.row_to_tree_assignment}
\title{Output row to tree assignment for the model and provided training data.}
\usage{
row_to_tree_assignment.H2OModel(object, original_training_data, ...)

h2o.row_to_tree_assignment(object, original_training_data, ...)
}
\arguments{
\item{object}{a fitted \linkS4class{H2OModel} object}

\item{original_training_data}{An H2OFrame object that was used for model training. Currently there is no validation of the input.}

\item{...}{additional arguments to pass on.}
}
\value{
Returns an H2OFrame contain row to tree assignment for each tree and row.
}
\description{
Output is frame of size nrow = nrow(original_training_data) and ncol = number_of_trees_in_model+1 in format: 
    row_id    tree_1    tree_2    tree_3
         0         0         1         1
         1         1         1         1
         2         1         0         0
         3         1         1         0
         4         0         1         1
         5         1         1         1
         6         1         0         0
         7         0         1         0
         8         0         1         1
         9         1         0         0
}
\details{
Where 1 in the tree_{number} cols means row is used in the tree and 0 means that row is not used.
The structure of the output depends on sample_rate or sample_size parameter setup.

Note: Multinomial classification generate tree for each category, each tree use the same sample of the data.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
prostate_gbm <- h2o.gbm(4:9, "AGE", prostate, sample_rate = 0.6)
# Get row to tree assignment
h2o.row_to_tree_assignment(prostate_gbm, prostate)
}
}
