% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.make_leaderboard}
\alias{h2o.make_leaderboard}
\title{Create a leaderboard from a list of models, grids and/or automls.}
\usage{
h2o.make_leaderboard(
  object,
  leaderboard_frame,
  sort_metric = "AUTO",
  extra_columns = c(),
  scoring_data = c("AUTO", "train", "valid", "xval")
)
}
\arguments{
\item{object}{List of models, automls, or grids; or just single automl/grid object.}

\item{leaderboard_frame}{Frame used for generating the metrics (optional).}

\item{sort_metric}{Metric used for sorting the leaderboard.}

\item{extra_columns}{What extra columns should be calculated (might require leaderboard_frame). Use "ALL" for all available or list of extra columns.}

\item{scoring_data}{Metrics to be reported in the leaderboard ("xval", "train", or "valid"). Used if no leaderboard_frame is provided.}
}
\value{
data.frame
}
\description{
Create a leaderboard from a list of models, grids and/or automls.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
iris_hf <- as.h2o(iris)
grid <- h2o.grid("gbm", x = c(1:4), y = 5, training_frame = iris_hf,
                 hyper_params = list(ntrees = c(1, 2, 3)))
h2o.make_leaderboard(grid, iris_hf)
}
}
