% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communication.R
\name{.h2o.doSafePOST}
\alias{.h2o.doSafePOST}
\title{Perform a safe (i.e. error-checked) HTTP POST request to an H2O cluster.}
\usage{
.h2o.doSafePOST(h2oRestApiVersion, urlSuffix, parms, fileUploadInfo, ...)
}
\arguments{
\item{h2oRestApiVersion}{(Optional) A version number to prefix to the urlSuffix.  If no version is provided, a default version is chosen for you.}

\item{urlSuffix}{The partial URL suffix to add to the calculated base URL for the instance}

\item{parms}{(Optional) Parameters to include in the request}

\item{fileUploadInfo}{(Optional) Information to POST (NOTE: changes Content-type from XXX-www-url-encoded to multi-part).  Use fileUpload(normalizePath("/path/to/file")).}

\item{...}{(Optional) Additional parameters.}
}
\value{
The raw response payload as a character vector
}
\description{
This function validates that no CURL error occurred and that the HTTP response code is successful.
If a failure occurred, then stop() is called with an error message.
Since all necessary error checking is done inside this call, the valid payload is directly returned if the function successfully finishes without calling stop().
}
