% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w2vutils.R
\name{h2o.transform_word2vec}
\alias{h2o.transform_word2vec}
\title{Transform words (or sequences of words) to vectors using a word2vec model.}
\usage{
h2o.transform_word2vec(
  word2vec,
  words,
  aggregate_method = c("NONE", "AVERAGE")
)
}
\arguments{
\item{word2vec}{A word2vec model.}

\item{words}{An H2OFrame made of a single column containing source words.}

\item{aggregate_method}{Specifies how to aggregate sequences of words. If method is `NONE`
then no aggregation is performed and each input word is mapped to a single word-vector.
If method is 'AVERAGE' then input is treated as sequences of words delimited by NA.
Each word of a sequences is internally mapped to a vector and vectors belonging to
the same sentence are averaged and returned in the result.}
}
\description{
Transform words (or sequences of words) to vectors using a word2vec model.
}
\examples{
\dontrun{
h2o.init()

# Build a dummy word2vec model
data <- as.character(as.h2o(c("a", "b", "a")))
w2v_model <- h2o.word2vec(data, sent_sample_rate = 0, min_word_freq = 0, epochs = 1, vec_size = 2)

# Transform words to vectors without aggregation
sentences <- as.character(as.h2o(c("b", "c", "a", NA, "b")))
h2o.transform(w2v_model, sentences) # -> 5 rows total, 2 rows NA ("c" is not in the vocabulary)

# Transform words to vectors and return average vector for each sentence
h2o.transform(w2v_model, sentences, aggregate_method = "AVERAGE") # -> 2 rows
}
}
