% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.merge}
\alias{h2o.merge}
\title{Merge Two H2O Data Frames}
\usage{
h2o.merge(x, y, by = intersect(names(x), names(y)), by.x = by, by.y = by,
  all = FALSE, all.x = all, all.y = all, method = "auto")
}
\arguments{
\item{x,y}{H2OFrame objects}

\item{by}{columns used for merging by default the common names}

\item{by.x}{x columns used for merging by name or number}

\item{by.y}{y columns used for merging by name or number}

\item{all}{TRUE includes all rows in x and all rows in y even if there is no match to the other}

\item{all.x}{If all.x is true, all rows in the x will be included, even if there is no matching
row in y, and vice-versa for all.y.}

\item{all.y}{see all.x}

\item{method}{auto(default), radix, hash}
}
\description{
Merges two H2OFrame objects with the same arguments and meanings
as merge() in base R.  However, we do not support all=TRUE, all.x=TRUE and all.y=TRUE.  The default method is auto
where the program will choose for you which merge method (hash or radix) to use automatically depending on the
contents of your left and right frames.  If there are duplicated
rows in your rite frame, they will not be included if you use the hash method.  Since it is rare to perform merge
with duplicated rows an the right frames, this should be okay.  On the other hand, the radix method will return the
correct merge result regardless of duplicated rows in the right frame.  However, it cannot merge frames containing
string columns.  User will have to convert the string columns to enum before proceeding.
}
\examples{
\donttest{
h2o.init()
left <- data.frame(fruit = c('apple', 'orange', 'banana', 'lemon', 'strawberry', 'blueberry'),
color <- c('red', 'orange', 'yellow', 'yellow', 'red', 'blue'))
right <- data.frame(fruit = c('apple', 'orange', 'banana', 'lemon', 'strawberry', 'watermelon'),
citrus <- c(FALSE, TRUE, FALSE, TRUE, FALSE, FALSE))
l.hex <- as.h2o(left)
r.hex <- as.h2o(right)
left.hex <- h2o.merge(l.hex, r.hex, all.x = TRUE)
}
}

