% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/svd.R
\name{h2o.svd}
\alias{h2o.svd}
\title{Singular value decomposition of an H2O data frame using the power method.}
\usage{
h2o.svd(training_frame, x, destination_key, model_id = NULL,
  validation_frame = NULL, ignore_const_cols = TRUE,
  score_each_iteration = FALSE, transform = c("NONE", "STANDARDIZE",
  "NORMALIZE", "DEMEAN", "DESCALE"), svd_method = c("GramSVD", "Power",
  "Randomized"), nv = 1, max_iterations = 1000, seed = -1,
  keep_u = TRUE, u_name = NULL, use_all_factor_levels = TRUE,
  max_runtime_secs = 0)
}
\arguments{
\item{training_frame}{Id of the training data frame (Not required, to allow initial validation of model parameters).}

\item{x}{A vector containing the \code{character} names of the predictors in the model.}

\item{destination_key}{(Optional) The unique hex key assigned to the resulting model.
Automatically generated if none is provided.}

\item{model_id}{Destination id for this model; auto-generated if not specified.}

\item{validation_frame}{Id of the validation data frame.}

\item{ignore_const_cols}{\code{Logical}. Ignore constant columns. Defaults to TRUE.}

\item{score_each_iteration}{\code{Logical}. Whether to score during each iteration of model training. Defaults to FALSE.}

\item{transform}{Transformation of training data Must be one of: "NONE", "STANDARDIZE", "NORMALIZE", "DEMEAN", "DESCALE".
Defaults to NONE.}

\item{svd_method}{Method for computing SVD (Caution: Randomized is currently experimental and unstable) Must be one of:
"GramSVD", "Power", "Randomized". Defaults to GramSVD.}

\item{nv}{Number of right singular vectors Defaults to 1.}

\item{max_iterations}{Maximum iterations Defaults to 1000.}

\item{seed}{Seed for random numbers (affects certain parts of the algo that are stochastic and those might or might not be enabled by default)
Defaults to -1 (time-based random number).}

\item{keep_u}{\code{Logical}. Save left singular vectors? Defaults to TRUE.}

\item{u_name}{Frame key to save left singular vectors}

\item{use_all_factor_levels}{\code{Logical}. Whether first factor level is included in each categorical expansion Defaults to TRUE.}

\item{max_runtime_secs}{Maximum allowed runtime in seconds for model training. Use 0 to disable. Defaults to 0.}
}
\value{
Returns an object of class \linkS4class{H2ODimReductionModel}.
}
\description{
Singular value decomposition of an H2O data frame using the power method.
}
\examples{
\donttest{
library(h2o)
h2o.init()
ausPath <- system.file("extdata", "australia.csv", package="h2o")
australia.hex <- h2o.uploadFile(path = ausPath)
h2o.svd(training_frame = australia.hex, nv = 8)
}
}
\references{
N. Halko, P.G. Martinsson, J.A. Tropp. {Finding structure with randomness: Probabilistic algorithms for constructing approximate matrix decompositions}[http://arxiv.org/abs/0909.4061]. SIAM Rev., Survey and Review section, Vol. 53, num. 2, pp. 217-288, June 2011.
}

