% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gyro.R
\encoding{UTF-8}
\name{gyroray}
\alias{gyroray}
\title{Gyroray}
\usage{
gyroray(O, A, s = 1, tmax = 20, OtoA = TRUE, model = "U", n = 300)
}
\arguments{
\item{O, A}{two distinct points (of the same dimension); the point
\code{O} is the origin of the gyroray}

\item{s}{positive number, the radius of the Poincaré ball if
\code{model="M"}, otherwise, if \code{model="U"}, this number
defines the hyperbolic curvature}

\item{tmax}{positive number controlling the length of the gyroray}

\item{OtoA}{Boolean, whether the gyroray must be directed from
\code{O} to \code{A} or must be the opposite one}

\item{model}{the hyperbolic model, either \code{"M"} (Möbius model, i.e.
Poincaré model) or \code{"U"} (Ungar model, i.e. hyperboloid model)}

\item{n}{number of points forming the gyroray}
}
\value{
A numeric matrix with \code{n} rows. Each row is a point of the
  gyroray with origin \code{O} (the first row) and passing through \code{A}
  or not, according to \code{OtoA}.
}
\description{
Gyroray given an origin and a point.
}
\examples{
library(gyro)
# a 2D example ####
O <- c(1, 2); A <- c(1, 1)
opar <- par(mar = c(2, 2, 2, 0.5))
plot(rbind(O, A), type = "p", pch = 19, xlab = NA, ylab = NA,
     xlim = c(0, 2), ylim = c(0, 3), main = "s = 0.3")
s <- 0.3
ray <- gyroray(O, A, s)
lines(ray, col = "blue", lwd = 2)
text(t(O), expression(italic(O)), pos = 2)
text(t(A), expression(italic(A)), pos = 3)
# opposite gyroray
yar <- gyroray(O, A, s, OtoA = FALSE)
lines(yar, col = "red", lwd = 2)
par(opar)
}
