% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{isSuspicious}
\alias{isSuspicious}
\title{Determine which results are suspicious}
\usage{
isSuspicious(result, pars = attr(result, "focus"))
}
\arguments{
\item{result}{output from \link{loadResults}}

\item{pars}{names of the parameters available in \code{result}}
}
\value{
a vector of logicals for each row of \code{result} indicating suspicion (if TRUE)
}
\description{
\lifecycle{maturing}
The \link{GWAS} function writes all results, both valid and
invalid, to a log file. This function uses heuristics to try to
classify rows as suspicious or unsuspicious.
}
\details{
OpenMx reports exceptions in the \sQuote{catch1}
  column. Any error message in the \sQuote{catch1} column is
  suspicious. Any optimizer status code besides \sQuote{OK} is
  suspicious. It is suspicious if the focal parameter or its
  standard error is \code{NA}. If \sQuote{signAdj} was requested
  and it is \code{NA} then suspicion is also aroused.
}
\examples{
tdir <- tempdir()
dir <- system.file("extdata", package = "gwsem")
pheno <- data.frame(anxiety=rnorm(500))
m1 <- buildItem(pheno, 'anxiety')
GWAS(m1, file.path(dir,"example.pgen"),
    file.path(tdir,"out.log"))
r1 <- loadResults(file.path(tdir,"out.log"), "snp_to_anxiety")
r1[isSuspicious(r1, "snp_to_anxiety"),]
}
\seealso{
Other reporting: 
\code{\link{loadResults}()},
\code{\link{plot.gwsemResult}()},
\code{\link{signifGxE}()},
\code{\link{signif}()}
}
\concept{reporting}
