% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{buildOneItem}
\alias{buildOneItem}
\title{Build a model suitable for a single item genome-wide association study}
\usage{
buildOneItem(phenoData, depVar, covariates = NULL, ...,
  fitfun = c("WLS", "ML"), minMAF = 0.01, modelType = c("RAM",
  "LISREL"), gxe = NULL)
}
\arguments{
\item{phenoData}{phenotype data with one individual per row}

\item{depVar}{the name of the single item to predict}

\item{covariates}{a vector of data column names to use as covariates}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{fitfun}{the name of the fit function to optimize}

\item{minMAF}{minimum minor allele frequency. Only used when \code{fitfun=WLS}}

\item{modelType}{whether to use the RAM or LISREL parameterization}

\item{gxe}{a vector of data column names. Creates additional data
columns named paste0('snp_',columnName) that are the
product of the SNP and the data in columnName}
}
\value{
A \link[OpenMx:MxModel-class]{MxModel}
}
\description{
Build a model suitable for a single item genome-wide association study
}
\details{
You can pass the result of this function to \link{GWAS} to run a GWAS.

Ordinal indicator thresholds are setup by
\link{setupThresholds}. Covariates adjustments are setup by
\link{setupCovariates}.
You can plot the model using \link[OpenMx]{omxGraphviz}.
}
\examples{
pheno <- data.frame(anxiety=cut(rnorm(500), c(-Inf, -.5, .5, Inf),
                    ordered_result = TRUE))
m1 <- buildOneItem(pheno, 'anxiety')
}
\seealso{
Other model builder: \code{\link{buildOneFacRes}},
  \code{\link{buildOneFac}}, \code{\link{buildTwoFac}}
}
\concept{model builder}
