% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptical.envelope.R
\name{elliptical.envelope}
\alias{elliptical.envelope}
\title{Simulated Envelope of Residuals for Elliptical Regression Models}
\usage{
elliptical.envelope(
  object,
  B = 100,
  arg,
  xlab = NULL,
  ylab = NULL,
  ident = NULL,
  ident.labels = NULL,
  ...
)
}
\arguments{
\item{object}{an object with the result of the fitted elliptical regression model.}

\item{B}{number of Monte Carlo simulations.}

\item{arg}{a numerical or vector representing the distribution parameters used in fitted model.}

\item{xlab}{a label for the x axis, defaults to a description of x.}

\item{ylab}{a label for the y axis, defaults to a description of y.}

\item{ident}{a numerical indicate the number of observation identified in plot.}

\item{ident.labels}{an optional character vector giving labels for the identified points.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\description{
This function produces quantile-quantile residuals plot with simulated envelope for the specified error distribution in elliptical regression models.
}
\examples{
data(luzdat)
y <- luzdat$y
x1 <- luzdat$x1 ; x1 <- factor(x1) ; x1 <- C(x1,treatment)
x2 <- luzdat$x2
x3 <- (luzdat$x2)^2
luz <- data.frame(y,x1,x2,x3)
elliptical.fitt <- elliptical(y ~ x1+x2+x3, family = Student(df=5),
data=luz)
elliptical.envelope(elliptical.fitt, B=100, arg=5)
}
\references{
Galea, M., Paula, G. A., and Cysneiros, F. J. A. (2005). On diagnostics in 
symmetrical nonlinear models. Statistics & Probability Letters, 73(4), 459-467.
\doi{10.1016/j.spl.2005.04.033}
}
\seealso{
\code{\link{glm}}, \code{\link{elliptical}}, \code{\link{family.elliptical}}
}
\keyword{Elliptical}
\keyword{Quantile-quantile}
\keyword{models}
\keyword{plots}
\keyword{regression}
