% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_variants.R
\name{get_variants}
\alias{get_variants}
\title{Get GWAS Catalog variants}
\usage{
get_variants(
  study_id = NULL,
  association_id = NULL,
  variant_id = NULL,
  efo_id = NULL,
  pubmed_id = NULL,
  genomic_range = NULL,
  cytogenetic_band = NULL,
  gene_name = NULL,
  efo_trait = NULL,
  reported_trait = NULL,
  set_operation = "union",
  interactive = TRUE,
  std_chromosomes_only = TRUE,
  verbose = FALSE,
  warnings = TRUE
)
}
\arguments{
\item{study_id}{A character vector of GWAS Catalog study accession
identifiers.}

\item{association_id}{A character vector of GWAS Catalog association
identifiers.}

\item{variant_id}{A character vector of GWAS Catalog variant identifiers.}

\item{efo_id}{A character vector of \href{https://www.ebi.ac.uk/efo/}{EFO}
identifiers.}

\item{pubmed_id}{An integer vector of
\href{https://pubmed.ncbi.nlm.nih.gov/}{PubMed} identifiers.}

\item{genomic_range}{A named list of three vectors:
\describe{ \item{chromosome}{A character vector of chromosome names of the
form 1--22, X or Y.} \item{start}{A numeric vector of start positions,
starting at 1.} \item{end}{A numeric vector of end positions.} }
The three vectors need to be of the same length so that \code{chromosome}
names, \code{start} and \code{end} positions can be matched by position.}

\item{cytogenetic_band}{A character vector of cytogenetic bands of the form
\code{'1p36.11'}.}

\item{gene_name}{Gene symbol according to
\href{https://www.genenames.org/}{HUGO Gene Nomenclature (HGNC)}.}

\item{efo_trait}{A character vector of
\href{https://www.ebi.ac.uk/efo/}{EFO} trait descriptions, e.g.,
\code{'uric acid measurement'}.}

\item{reported_trait}{A character vector of phenotypic traits as
reported by the original authors of the study.}

\item{set_operation}{Either \code{'union'} or \code{'intersection'}. This
tells how variants retrieved by different criteria  should be combined:
\code{'union'} binds together all results removing duplicates and
\code{'intersection'} only keeps same variants found with different
criteria.}

\item{interactive}{A logical. If all variants are requested, whether to ask
interactively if we really want to proceed.}

\item{std_chromosomes_only}{Whether to return only variants mapped to
standard chromosomes: 1 thru 22, X, Y, and MT.}

\item{verbose}{Whether the function should be
verbose about the different queries or not.}

\item{warnings}{Whether to print warnings.}
}
\value{
A \linkS4class{variants} object.
}
\description{
Retrieves variants via the NHGRI-EBI GWAS Catalog REST API. The REST
API is queried multiple times with the criteria passed as arguments (see
below). By default all variants that match the criteria supplied in the
arguments are retrieved: this corresponds to the default option
\code{set_operation} set to \code{'union'}. If you rather have only the
variants that match simultaneously all criteria provided, then set
\code{set_operation} to \code{'intersection'}.
}
\details{
Please note that all search criteria are vectorised, thus allowing for batch
mode search, e.g., one can search by multiple variant identifiers at once by
passing a vector of identifiers to \code{variant_id}.
}
\examples{
# Get variants by study identifier
get_variants(study_id = 'GCST001085', warnings = FALSE)

# Get a variant by its identifier
get_variants(variant_id = 'rs3798440', warnings = FALSE)

}
