% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_traits.R
\name{get_traits_by_efo_trait}
\alias{get_traits_by_efo_trait}
\title{Get GWAS Catalog traits by EFO traits}
\usage{
get_traits_by_efo_trait(
  efo_trait = NULL,
  verbose = FALSE,
  warnings = TRUE,
  page_size = 20L
)
}
\arguments{
\item{efo_trait}{A \code{character} vector of
\href{https://www.ebi.ac.uk/efo/}{EFO} trait descriptions, e.g.,
\code{'uric acid measurement'}.}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if any.}

\item{page_size}{An \code{integer} scalar indicating the
\href{https://www.ebi.ac.uk/gwas/rest/docs/api#_paging_resources}{page}
value to be used in the JSON requests, can be between \code{1} and
\code{1000}.}
}
\value{
A \linkS4class{traits} object.
}
\description{
Gets traits that match \href{https://www.ebi.ac.uk/efo/}{EFO} trait
description.
}
\keyword{internal}
