% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_traits.R
\name{get_traits}
\alias{get_traits}
\title{Get GWAS Catalog EFO traits}
\usage{
get_traits(
  study_id = NULL,
  association_id = NULL,
  efo_id = NULL,
  pubmed_id = NULL,
  efo_uri = NULL,
  efo_trait = NULL,
  set_operation = "union",
  verbose = FALSE,
  warnings = TRUE
)
}
\arguments{
\item{study_id}{A \code{character} vector of GWAS Catalog study accession
identifiers.}

\item{association_id}{A \code{character} vector of GWAS Catalog association
identifiers.}

\item{efo_id}{A character vector of \href{https://www.ebi.ac.uk/efo/}{EFO}
identifiers.}

\item{pubmed_id}{An \code{integer} vector of
\href{https://en.wikipedia.org/wiki/PubMed}{PubMed} identifiers.}

\item{efo_uri}{A \code{character} vector of \href{https://www.ebi.ac.uk/efo/}{EFO} URIs.}

\item{efo_trait}{A \code{character} vector of
\href{https://www.ebi.ac.uk/efo/}{EFO} trait descriptions, e.g.,
\code{'uric acid measurement'}.}

\item{set_operation}{Either \code{'union'} or \code{'intersection'}. This
tells how traits retrieved by different criteria  should be combined:
\code{'union'} binds together all results removing duplicates and
\code{'intersection'} only keeps same traits found with different
criteria.}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if any.}
}
\value{
A \linkS4class{traits} object.
}
\description{
Retrieves traits via the NHGRI-EBI GWAS Catalog REST API. The REST
API is queried multiple times with the criteria passed as arguments (see
below). By default all traits that match the criteria supplied in the
arguments are retrieved: this corresponds to the default option
\code{set_operation} set to \code{'union'}. If you rather have only the
traits that match simultaneously all criteria provided, then set
\code{set_operation} to \code{'intersection'}.
}
\details{
Please note that all search criteria are vectorised, thus allowing for batch
mode search, e.g., one can search by multiple trait identifiers at once by
passing a vector of identifiers to \code{efo_id}.
}
\examples{
# Get traits by study identifier
get_traits(study_id = 'GCST001085', warnings = FALSE)

# Get traits by association identifier
get_traits(association_id = '25389945', warnings = FALSE)

# Get a trait by its EFO identifier
get_traits(efo_id = 'EFO_0005537', warnings = FALSE)

}
