% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_studies.R
\name{get_studies}
\alias{get_studies}
\title{Get GWAS Catalog studies}
\usage{
get_studies(
  study_id = NULL,
  association_id = NULL,
  variant_id = NULL,
  efo_id = NULL,
  pubmed_id = NULL,
  user_requested = NULL,
  full_pvalue_set = NULL,
  efo_uri = NULL,
  efo_trait = NULL,
  reported_trait = NULL,
  set_operation = "union",
  interactive = TRUE,
  verbose = FALSE,
  warnings = TRUE
)
}
\arguments{
\item{study_id}{A character vector of GWAS Catalog study accession
identifiers.}

\item{association_id}{A character vector of GWAS Catalog association
identifiers.}

\item{variant_id}{A character vector of GWAS Catalog variant identifiers.}

\item{efo_id}{A character vector of \href{https://www.ebi.ac.uk/efo/}{EFO}
identifiers.}

\item{pubmed_id}{An integer vector of
\href{https://en.wikipedia.org/wiki/PubMed}{PubMed} identifiers.}

\item{user_requested}{A \code{logical} (scalar!) indicating to retrieve either studies
requested by users of the Catalog (\code{TRUE}) or otherwise
(\code{FALSE}).}

\item{full_pvalue_set}{A \code{logical} (scalar!) indicating to retrieve studies with full
summary statistics (\code{TRUE}) or studies without it (\code{FALSE}).}

\item{efo_uri}{A character vector of \href{https://www.ebi.ac.uk/efo/}{EFO} URIs.}

\item{efo_trait}{A character vector of
\href{https://www.ebi.ac.uk/efo/}{EFO} trait descriptions, e.g.,
\code{'uric acid measurement'}.}

\item{reported_trait}{A character vector of phenotypic traits as
reported by the original authors of the study.}

\item{set_operation}{Either \code{'union'} or \code{'intersection'}. This
tells how studies retrieved by different criteria  should be combined:
\code{'union'} binds together all results removing duplicates and
\code{'intersection'} only keeps same studies found with different
criteria.}

\item{interactive}{A logical. If all studies are requested, whether to ask
interactively if we really want to proceed.}

\item{verbose}{Whether the function should be verbose about the different
queries or not.}

\item{warnings}{Whether to print warnings.}
}
\value{
A \linkS4class{studies} object.
}
\description{
Retrieves studies via the NHGRI-EBI GWAS Catalog REST API. The REST
API is queried multiple times with the criteria passed as arguments (see
below). By default all studies that match the criteria supplied in the
arguments are retrieved: this corresponds to the default option
\code{set_operation} set to \code{'union'}. If you rather have only the
studies that match simultaneously all criteria provided, then set
\code{set_operation} to \code{'intersection'}.
}
\details{
Please note that all search criteria are vectorised, thus allowing for batch
mode search, e.g., one can search by multiple variant identifiers at once by
passing a vector of identifiers to \code{variant_id}.
}
\examples{
# Get a study by its accession identifier
get_studies(study_id = 'GCST001085', warnings = FALSE)

# Get a study by association identifier
get_studies(association_id = '25389945', warnings = FALSE)

# Get studies by variant identifier
get_studies(variant_id = 'rs3798440', warnings = FALSE)

# Get studies by EFO trait identifier
get_studies(efo_id = 'EFO_0005537', warnings = FALSE)

}
