% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gvc.R
\name{gvc}
\alias{gvc}
\title{Genotypic Variance}
\description{
The `gvc` class calculates genotypic variance, phenotypic variance, and broad-sense heritability from replicated data.
}
\details{
The `gvc` class uses methods explained by Burton, G. W. & Devane, E. H. (1953) and Allard, R.W. (2010). It includes methods for calculating genetic variance, phenotypic variance, and heritability.
}
\examples{
df1 <- data.frame(
           Response = c(
                          rnorm(48, mean = 15000, sd = 500)
                        , rnorm(48, mean =  5000, sd = 500)
                        , rnorm(48, mean =  1000, sd = 500)
                       )
        , Rep      = as.factor(rep(1:3, each = 48))
        , Variety  = gl(n = 4, k =  4, length = 144, labels = letters[1:4])
        , Env      = gl(n = 3, k = 16, length = 144, labels = letters[1:3])
        )

# Create an instance of the class
gvc1 <- gvc$new(
           .data = df1
         , .y    = Response
         , .rep  = Rep
         , .gen  = Variety
         , .env  = Env
         )

# Calculate genetic variance (gvar)
gvc1$calculate_gvar()

# Calculate phenotypic variance (pvar)
gvc1$calculate_pvar()

# Calculate heritability (h2)
gvc1$calculate_herit()

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{A `tibble` containing the data for analysis.}

\item{\code{y}}{The name of the response variable.}

\item{\code{x}}{The name of the covariate (optional).}

\item{\code{rep}}{The name of the replicate factor.}

\item{\code{gen}}{The name of the genotype factor.}

\item{\code{env}}{The name of the environmental factor.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-gvc-new}{\code{gvc$new()}}
\item \href{#method-gvc-calculate_gvar}{\code{gvc$calculate_gvar()}}
\item \href{#method-gvc-calculate_pvar}{\code{gvc$calculate_pvar()}}
\item \href{#method-gvc-calculate_herit}{\code{gvc$calculate_herit()}}
\item \href{#method-gvc-clone}{\code{gvc$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gvc-new"></a>}}
\if{latex}{\out{\hypertarget{method-gvc-new}{}}}
\subsection{Method \code{new()}}{
Initialize the `gvc` class with the data and variable names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{gvc$new(.data, .y, .x = NULL, .rep, .gen, .env)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{.data}}{A `data.frame` containing the data for analysis.}

\item{\code{.y}}{The response variable.}

\item{\code{.x}}{The covariate (optional).}

\item{\code{.rep}}{The replicate factor.}

\item{\code{.gen}}{The genotype factor.}

\item{\code{.env}}{The environmental factor.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of the `gvc` class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gvc-calculate_gvar"></a>}}
\if{latex}{\out{\hypertarget{method-gvc-calculate_gvar}{}}}
\subsection{Method \code{calculate_gvar()}}{
Calculate genetic variance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{gvc$calculate_gvar()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with the genetic variance (`gvar`).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gvc-calculate_pvar"></a>}}
\if{latex}{\out{\hypertarget{method-gvc-calculate_pvar}{}}}
\subsection{Method \code{calculate_pvar()}}{
Calculate phenotypic variance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{gvc$calculate_pvar()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with the phenotypic variance (`pvar`).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gvc-calculate_herit"></a>}}
\if{latex}{\out{\hypertarget{method-gvc-calculate_herit}{}}}
\subsection{Method \code{calculate_herit()}}{
Calculate broad-sense heritability.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{gvc$calculate_herit()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with the heritability (`h2`).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gvc-clone"></a>}}
\if{latex}{\out{\hypertarget{method-gvc-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{gvc$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
