set.seed(1234)
X <- matrix(rbinom(10*20, 10, 0.1), nrow=10, ncol=20)
Y <- matrix(rbinom(10*15, 10, 0.1), nrow=10, ncol=15)

out1 <- sPLSDA(X, Y, k=2, thr=1)
out2 <- sPLSDA(X, Y, k=2, thr=1, fullrank=TRUE)
out3 <- sPLSDA(X, Y, k=2, thr=1, cortest=TRUE)

expect_equal(dim(out1$scoreX), c(nrow(X), 2))
expect_equal(dim(out1$loadingX), c(ncol(X), 2))
expect_equal(dim(out1$scoreY), c(nrow(Y), 2))
expect_equal(dim(out1$loadingY), c(ncol(Y), 2))
expect_equal(length(out1$d), 2)

expect_equal(dim(out2$scoreX), c(nrow(X), 2))
expect_equal(dim(out2$loadingX), c(ncol(X), 2))
expect_equal(dim(out2$scoreY), c(nrow(Y), 2))
expect_equal(dim(out2$loadingY), c(ncol(Y), 2))
expect_equal(length(out2$d), 2)

expect_equal(dim(out3$scoreX), c(nrow(X), 2))
expect_equal(dim(out3$loadingX), c(ncol(X), 2))
expect_equal(dim(out3$scoreY), c(nrow(Y), 2))
expect_equal(dim(out3$loadingY), c(ncol(Y), 2))
expect_equal(length(out3$d), 2)
expect_equal(dim(out3$corX), c(ncol(X), 2))
expect_equal(dim(out3$corY), c(ncol(Y), 2))
expect_equal(dim(out3$pvalX), c(ncol(X), 2))
expect_equal(dim(out3$pvalY), c(ncol(Y), 2))
expect_equal(dim(out3$qvalX), c(ncol(X), 2))
expect_equal(dim(out3$qvalY), c(ncol(Y), 2))
