% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_dependencies.R
\name{install_dependencies}
\alias{install_dependencies}
\title{Install / Update project dependencies}
\usage{
install_dependencies(dependencies = NULL, ask = TRUE)
}
\arguments{
\item{dependencies}{An optional list of dependencies. If \code{NULL}, will be
determined with \code{\link[renv:dependencies]{renv::dependencies()}}. If equal to \code{"old"}, will use the
list returned by \code{\link[utils:update.packages]{utils::old.packages()}}.}

\item{ask}{Whether to ask for confirmation when installing a different
version of a package that is already installed. Installations that only add
new packages never require confirmation.}
}
\value{
(Invisibly) A data frame with information about the installed
package(s).
}
\description{
This function uses \code{\link[renv:dependencies]{renv::dependencies()}} to identify R package dependencies
in a project and then calls \code{\link[pak:pkg_install]{pak::pkg_install()}} to install / update these
packages. If some packages are not found, the function will install those
available and returns a message indicated packages not installed/updated.
}
\examples{
\dontrun{
install_dependencies()
}
}
\keyword{utilities}
