% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unrowwise.R
\name{unrowwise}
\alias{unrowwise}
\title{Remove row-wise grouping}
\usage{
unrowwise(data)
}
\arguments{
\item{data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame.}
}
\value{
A tibble.
}
\description{
Remove row-wise grouping created with \code{\link[dplyr:rowwise]{dplyr::rowwise()}} while preserving
any other grouping declared with \code{\link[dplyr:group_by]{dplyr::group_by()}}.
}
\examples{
titanic |> dplyr::rowwise()
titanic |> dplyr::rowwise() |> unrowwise()

titanic |> dplyr::group_by(Sex, Class) |> dplyr::rowwise()
titanic |> dplyr::group_by(Sex, Class) |> dplyr::rowwise() |> unrowwise()
}
\keyword{manip}
