% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_footnote.R
\name{modify_footnote2}
\alias{modify_footnote2}
\alias{modify_footnote_header}
\alias{modify_footnote_body}
\alias{modify_footnote_spanning_header}
\alias{remove_footnote_header}
\alias{remove_footnote_body}
\alias{remove_footnote_spanning_header}
\title{Modify Footnotes}
\usage{
modify_footnote_header(
  x,
  footnote,
  columns,
  replace = TRUE,
  text_interpret = c("md", "html")
)

modify_footnote_body(
  x,
  footnote,
  columns,
  rows,
  replace = TRUE,
  text_interpret = c("md", "html")
)

modify_footnote_spanning_header(
  x,
  footnote,
  columns,
  level = 1L,
  replace = TRUE,
  text_interpret = c("md", "html")
)

remove_footnote_header(x, columns)

remove_footnote_body(x, columns, rows)

remove_footnote_spanning_header(x, columns, level)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
A gtsummary object}

\item{footnote}{(\code{string})\cr
a string}

\item{columns}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to add footnote.

For \code{modify_footnote_spanning_header()}, pass a single column name where
the spanning header begins. If multiple column names are passed, only
the first is used.}

\item{replace}{(scalar \code{logical})\cr
Logical indicating whether to replace any existing footnotes in the specified
location with the specified footnote, or whether the specified should
be added to the existing footnote(s) in the header/cell. Default
is to replace existing footnotes.}

\item{text_interpret}{(\code{string})\cr
String indicates whether text will be interpreted with
\code{\link[gt:md]{gt::md()}} or \code{\link[gt:html]{gt::html()}}. Must be \code{"md"} (default) or \code{"html"}.
Applies to tables printed with \code{{gt}}.}

\item{rows}{(predicate \code{expression})\cr
Predicate expression to select rows in \code{x$table_body}.
Review \link[=rows_argument]{rows argument details}.}

\item{level}{(\code{integer})\cr
An integer specifying which level to place the spanning header footnote.}
}
\value{
Updated gtsummary object
}
\description{
Modify Footnotes
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
tbl <- trial |>
  tbl_summary(by = trt, include = c(age, grade), missing = "no") |>
  modify_footnote_header(
    footnote = "All but four subjects received both treatments in a crossover design",
    columns = all_stat_cols(),
    replace = FALSE
  ) |>
  modify_footnote_body(
    footnote = "Tumor grade was assessed _before_ treatment began",
    columns = "label",
    rows = variable == "grade" & row_type == "label"
  )
tbl

# Example 2 ----------------------------------
# remove all footnotes
tbl |>
  remove_footnote_header(columns = all_stat_cols()) |>
  remove_footnote_body(columns = label, rows = variable == "grade" & row_type == "label")
\dontshow{\}) # examplesIf}
}
