% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_column_alignment.R
\name{modify_column_alignment}
\alias{modify_column_alignment}
\title{Modify column alignment}
\usage{
modify_column_alignment(x, columns, align = c("left", "right", "center"))
}
\arguments{
\item{x}{(\code{gtsummary})\cr
gtsummary object}

\item{columns}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Selector of columns in \code{x$table_body}}

\item{align}{(\code{string})
String indicating alignment of column, must be one of \code{c("left", "right", "center")}}
}
\description{
Update column alignment/justification in a gtsummary table.
}
\examples{
# Example 1 ----------------------------------
lm(age ~ marker + grade, trial) \%>\%
  tbl_regression() \%>\%
  modify_column_alignment(columns = everything(), align = "left")
}
