% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_p.tbl_cross.R
\name{add_p.tbl_cross}
\alias{add_p.tbl_cross}
\title{Add p-value}
\usage{
\method{add_p}{tbl_cross}(
  x,
  test = NULL,
  pvalue_fun = ifelse(source_note, label_style_pvalue(digits = 1, prepend_p = TRUE),
    label_style_pvalue(digits = 1)),
  source_note = FALSE,
  test.args = NULL,
  ...
)
}
\arguments{
\item{x}{(\code{tbl_cross})\cr
Object with class \code{tbl_cross} created with the \code{\link[=tbl_cross]{tbl_cross()}} function}

\item{test}{(\code{string})\cr
A string specifying statistical test to perform. Default is
\code{"chisq.test"} when expected cell counts >=5 and "\code{fisher.test}" when
expected cell counts <5.}

\item{pvalue_fun}{(\code{function})\cr
Function to round and format p-value.
Default is \code{label_style_pvalue(digits = 1)}, except when \code{source_note = TRUE} when the
default is \code{label_style_pvalue(digits = 1, prepend_p = TRUE)}}

\item{source_note}{(scalar \code{logical})\cr
Logical value indicating whether to show p-value
in the \{gt\} table source notes rather than a column.}

\item{test.args}{(named \code{list})\cr
Named list containing additional arguments to pass to
the test (if it accepts additional arguments).
For example, add an argument for a chi-squared test with
\code{test.args = list(correct = TRUE)}}

\item{...}{These dots are for future extensions and must be empty.}
}
\description{
Calculate and add a p-value comparing the two variables in the cross table.
If missing levels are included in the tables, they are also included in p-value calculation.
}
\examples{
# Example 1 ----------------------------------
trial |>
  tbl_cross(row = stage, col = trt) |>
  add_p()

# Example 2 ----------------------------------
trial |>
  tbl_cross(row = stage, col = trt) |>
  add_p(source_note = TRUE)
}
\author{
Karissa Whiting, Daniel D. Sjoberg
}
\concept{tbl_cross tools}
