% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_column_indent.R
\name{modify_column_indent}
\alias{modify_column_indent}
\title{Add/Remove Indentation}
\usage{
modify_column_indent(
  x,
  columns,
  rows = NULL,
  double_indent = FALSE,
  undo = FALSE
)
}
\arguments{
\item{x}{a gtsummary table}

\item{columns}{columns to add indentation to}

\item{rows}{predicate expression to select rows to indent. Default is \code{NULL},
indicating all rows}

\item{double_indent}{logical indicating whether to double indent the cells.
Default is \code{FALSE} for a single indentation}

\item{undo}{logical indicating whether an indentation should be removed/undone.
Default is \code{FALSE}}
}
\value{
a gtsummary table
}
\description{
Add/Remove Indentation
}
\examples{
# remove indentation from `tbl_summary()`
modify_column_indent_ex1 <-
  trial \%>\%
  select(grade) \%>\%
  tbl_summary() \%>\%
  modify_column_indent(columns = label, undo = TRUE)
}
\seealso{
Other Advanced modifiers: 
\code{\link{modify_column_alignment}()},
\code{\link{modify_column_hide}()},
\code{\link{modify_column_merge}()},
\code{\link{modify_fmt_fun}()},
\code{\link{modify_table_body}()},
\code{\link{modify_table_styling}()}
}
\concept{Advanced modifiers}
