% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_p.R
\name{add_p.tbl_continuous}
\alias{add_p.tbl_continuous}
\title{P-values for \code{tbl_continuous}}
\usage{
\method{add_p}{tbl_continuous}(
  x,
  test = NULL,
  pvalue_fun = NULL,
  include = everything(),
  test.args = NULL,
  group = NULL,
  ...
)
}
\arguments{
\item{x}{Object with class \code{tbl_summary} from the \link{tbl_summary} function}

\item{test}{List of formulas specifying statistical tests to perform for each
variable.
Default is two-way ANOVA when \verb{by=} is not \code{NULL}, and has the same defaults
as \code{add_p.tbl_continuous()} when \code{by = NULL}.
See \link{tests} for details, more tests, and instruction for implementing a custom test.}

\item{pvalue_fun}{Function to round and format p-values.
Default is \link{style_pvalue}.
The function must have a numeric vector input (the numeric, exact p-value),
and return a string that is the rounded/formatted p-value (e.g.
\code{pvalue_fun = function(x) style_pvalue(x, digits = 2)} or equivalently,
\code{purrr::partial(style_pvalue, digits = 2)}).}

\item{include}{Variables to include in output. Input may be a vector of
quoted variable names, unquoted variable names, or tidyselect select helper
functions. Default is \code{everything()}.}

\item{test.args}{List of formulas containing additional arguments to pass to
tests that accept arguments. For example, add an argument for all t-tests,
use \code{test.args = all_tests("t.test") ~ list(var.equal = TRUE)}}

\item{group}{Column name (unquoted or quoted) of an ID or grouping variable.
The column can be used to calculate p-values with correlated data.
Default is \code{NULL}. See \link{tests} for methods that utilize the \verb{group=} argument.}

\item{...}{Not used}
}
\description{
P-values for \code{tbl_continuous}
}
\examples{
add_p_continuous_ex1 <-
  tbl_continuous(
    data = trial,
    variable = age,
    by = trt,
    include = grade
  ) \%>\%
  add_p()
}
