% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_regression_methods.R
\name{tbl_regression_methods}
\alias{tbl_regression_methods}
\alias{tbl_regression.model_fit}
\alias{tbl_regression.workflow}
\alias{tbl_regression.survreg}
\alias{tbl_regression.mira}
\alias{tbl_regression.mipo}
\alias{tbl_regression.lmerMod}
\alias{tbl_regression.glmerMod}
\alias{tbl_regression.glmmTMB}
\alias{tbl_regression.glmmadmb}
\alias{tbl_regression.stanreg}
\alias{tbl_regression.brmsfit}
\alias{tbl_regression.gam}
\alias{tbl_regression.multinom}
\title{Methods for tbl_regression}
\usage{
\method{tbl_regression}{model_fit}(x, ...)

\method{tbl_regression}{workflow}(x, ...)

\method{tbl_regression}{survreg}(
  x,
  tidy_fun = function(x, ...) broom::tidy(x, ...) \%>\% dplyr::filter(.data$term !=
    "Log(scale)"),
  ...
)

\method{tbl_regression}{mira}(x, tidy_fun = pool_and_tidy_mice, ...)

\method{tbl_regression}{mipo}(x, ...)

\method{tbl_regression}{lmerMod}(
  x,
  tidy_fun = function(x, ...) broom.mixed::tidy(x, ..., effects = "fixed"),
  ...
)

\method{tbl_regression}{glmerMod}(
  x,
  tidy_fun = function(x, ...) broom.mixed::tidy(x, ..., effects = "fixed"),
  ...
)

\method{tbl_regression}{glmmTMB}(
  x,
  tidy_fun = function(x, ...) broom.mixed::tidy(x, ..., effects = "fixed"),
  ...
)

\method{tbl_regression}{glmmadmb}(
  x,
  tidy_fun = function(x, ...) broom.mixed::tidy(x, ..., effects = "fixed"),
  ...
)

\method{tbl_regression}{stanreg}(
  x,
  tidy_fun = function(x, ...) broom.mixed::tidy(x, ..., effects = "fixed"),
  ...
)

\method{tbl_regression}{brmsfit}(
  x,
  tidy_fun = function(x, ...) broom.mixed::tidy(x, ..., effects = "fixed"),
  ...
)

\method{tbl_regression}{gam}(x, tidy_fun = tidy_gam, ...)

\method{tbl_regression}{multinom}(x, ...)
}
\arguments{
\item{x}{Regression model object}

\item{...}{arguments passed to \code{tbl_regression.default()}}

\item{tidy_fun}{Option to specify a particular tidier function for the
model. Default is to use \code{broom::tidy}, but if an error occurs
then tidying of the model is attempted with \code{parameters::model_parameters()},
if installed.}
}
\description{
Most regression models are handled by \code{\link[=tbl_regression.default]{tbl_regression.default()}},
which uses \code{\link[broom:reexports]{broom::tidy()}} to perform initial tidying of results. There are,
however, some model types that have modified default printing behavior.
Those methods are listed below.
}
\section{Methods}{


The default method for \code{tbl_regression()} model summary uses \code{broom::tidy(x)}
to perform the initial tidying of the model object. There are, however,
a few models that use \link[=tbl_regression_methods]{modifications}.
\itemize{
\item \code{"parsnip/workflows"}: If the model was prepared using parsnip/workflows,
the original model fit is extracted and the original \verb{x=} argument
is replaced with the model fit. This will typically go unnoticed; however,if you've
provided a custom tidier in \verb{tidy_fun=} the tidier will be applied to the model
fit object and not the parsnip/workflows object.
\item \code{"survreg"}: The scale parameter is removed, \code{broom::tidy(x) \%>\% dplyr::filter(term != "Log(scale)")}
\item \code{"multinom"}: This multinomial outcome is complex, with one line per covariate per outcome (less the reference group)
\item \code{"gam"}: Uses the internal tidier \code{tidy_gam()} to print both parametric and smooth terms.
\item \code{"lmerMod"}, \code{"glmerMod"}, \code{"glmmTMB"}, \code{"glmmadmb"}, \code{"stanreg"}, \code{"brmsfit"}: These mixed effects
models use \code{broom.mixed::tidy(x, effects = "fixed")}. Specify \code{tidy_fun = broom.mixed::tidy}
to print the random components.
}
}

