% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_stat_label.R
\name{add_stat_label}
\alias{add_stat_label}
\title{Add statistic labels}
\usage{
add_stat_label(x, location = NULL, label = NULL)
}
\arguments{
\item{x}{Object with class \code{tbl_summary} from the \link{tbl_summary} function}

\item{location}{location where statistic label will be included.
\code{"row"} (the default) to add the statistic label to the variable label row,
and \code{"column"} adds a column with the statistic label.}

\item{label}{a list of formulas or a single formula updating the statistic
label, e.g. \code{label = all_categorical() ~ "No. (\%)"}}
}
\value{
A \code{tbl_summary} object
}
\description{
Adds labels describing the summary statistics presented for
each variable in the \link{tbl_summary} table.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{add_stat_label_ex1.png}{options: width=60\%}}

\if{html}{Example 2}

\if{html}{\figure{add_stat_label_ex2.png}{options: width=60\%}}
}

\examples{
tbl <- trial \%>\%
  dplyr::select(trt, age, grade, response) \%>\%
  tbl_summary(by = trt)

# Example 1 ----------------------------------
# Add statistic presented to the variable label row
add_stat_label_ex1 <-
  tbl \%>\%
  add_stat_label(
    # update default statistic label for continuous variables
    label = all_continuous() ~ "med. (iqr)"
  )

# Example 2 ----------------------------------
add_stat_label_ex2 <-
  tbl \%>\%
  add_stat_label(
    # add a new column with statistic labels
    location = "column"
  )

}
\seealso{
Other tbl_summary tools: 
\code{\link{add_n}()},
\code{\link{add_overall}()},
\code{\link{add_p.tbl_summary}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_summary}()},
\code{\link{inline_text.tbl_survfit}()},
\code{\link{modify_footnote}()},
\code{\link{modify_header}()},
\code{\link{modify_spanning_header}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_summary}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_summary tools}
