% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traveltimes.R
\name{gtfs_traveltimes}
\alias{gtfs_traveltimes}
\title{gtfs_traveltimes}
\usage{
gtfs_traveltimes(
  gtfs,
  from,
  start_time_limits,
  day = NULL,
  from_is_id = FALSE,
  grep_fixed = TRUE,
  route_pattern = NULL,
  minimise_transfers = FALSE,
  max_traveltime = 60 * 60,
  quiet = FALSE
)
}
\arguments{
\item{gtfs}{A set of GTFS data returned from \link{extract_gtfs} or, for more
efficient queries, pre-processed with \link{gtfs_timetable}.}

\item{from}{Name, ID, or approximate (lon, lat) coordinates of start station
(as \code{stop_name} or \code{stop_id} entry in the \code{stops} table, or a vector of two
numeric values).}

\item{start_time_limits}{A vector of two integer values denoting the earliest
and latest departure times in seconds for the traveltime values.}

\item{day}{Day of the week on which to calculate route, either as an
unambiguous string (so "tu" and "th" for Tuesday and Thursday), or a number
between 1 = Sunday and 7 = Saturday. If not given, the current day will be
used. (Not used if \code{gtfs} has already been prepared with
\link{gtfs_timetable}.)}

\item{from_is_id}{Set to \code{TRUE} to enable \code{from} parameter to specify entry
in \code{stop_id} rather than \code{stop_name} column of the \code{stops} table (same as
\code{from_to_are_ids} parameter of \link{gtfs_route}).}

\item{grep_fixed}{If \code{FALSE}, match station names (when passed as character
string) with \code{grep(..., fixed = FALSE)}, to allow use of \code{grep} expressions.
This is useful to refine matches in cases where desired stations may match
multiple entries.}

\item{route_pattern}{Using only those routes matching given pattern, for
example, "^U" for routes starting with "U" (as commonly used for underground
or subway routes. To negate the \code{route_pattern} -- that is, to include all
routes except those matching the pattern -- prepend the value with "!"; for
example "!^U" will include all services except those starting with "U". (This
parameter is not used at all if \code{gtfs} has already been prepared with
\link{gtfs_timetable}.)}

\item{minimise_transfers}{If \code{TRUE}, isochrones are calculated with
minimal-transfer connections to each end point, even if those connections are
slower than alternative connections with transfers.}

\item{max_traveltime}{The maximal traveltime to search for, specified in
seconds (with default of 1 hour). See note for details.}

\item{quiet}{Set to \code{TRUE} to suppress screen messages (currently just
regarding timetable construction).}
}
\description{
Travel times from a nominated station departing at a nominated time to every
other reachable station in a system.
}
\note{
Higher values of \code{max_traveltime} will return traveltimes for greater
numbers of stations, but may lead to considerably longer calculation times.
For repeated usage, it is recommended to first establish a value sufficient
to reach all or most stations desired for a particular query, rather than set
\code{max_traveltime} to an arbitrarily high value.
}
\examples{
berlin_gtfs_to_zip ()
f <- file.path (tempdir (), "vbb.zip")
g <- extract_gtfs (f)
g <- gtfs_timetable (g)
from <- "Alexanderplatz"
start_times <- 12 * 3600 + c (0, 60) * 60 # 8:00-9:00
res <- gtfs_traveltimes (g, from, start_times)
}
