% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_columns.R
\name{cols_move}
\alias{cols_move}
\title{Move one or more columns}
\usage{
cols_move(data, columns, after)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The column names to move to as a group to a different
position. The order of the remaining columns will be preserved.}

\item{after}{A column name used to anchor the insertion of the moved columns.
All of the moved columns will be placed to the right of this column.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
On those occasions where you need to move columns this way or that way, we
can make use of the \code{cols_move()} function. While it's true that the movement
of columns can be done upstream of \strong{gt}, it is much easier and less error
prone to use the function provided here. The movement procedure here takes
one or more specified columns (in the \code{columns} argument) and places them to
the right of a different column (the \code{after} argument). The ordering of the
\code{columns} to be moved is preserved, as is the ordering of all other columns
in the table.
}
\details{
The columns supplied in \code{columns} must all exist in the table and none of
them can be in the \code{after} argument. The \code{after} column must also exist and
only one column should be provided here. If you need to place one or columns
at the beginning of the column series, the \code{\link[=cols_move_to_start]{cols_move_to_start()}} function
should be used. Similarly, if those columns to move should be placed at the
end of the column series then use \code{\link[=cols_move_to_end]{cols_move_to_end()}}.
}
\section{Examples}{


Use \code{\link{countrypops}} to create a \strong{gt} table. With the remaining columns,
position \code{population} after \code{country_name} with the \code{cols_move()} function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{countrypops |>
  dplyr::select(-contains("code")) |>
  dplyr::filter(country_name == "Mongolia") |>
  tail(5) |>
  gt() |>
  cols_move(
    columns = population,
    after = country_name
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cols_move_1.png" alt="This image of a table was generated from the first code example in the `cols_move()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

5-6
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other column modification functions: 
\code{\link{cols_align_decimal}()},
\code{\link{cols_align}()},
\code{\link{cols_hide}()},
\code{\link{cols_label_with}()},
\code{\link{cols_label}()},
\code{\link{cols_merge_n_pct}()},
\code{\link{cols_merge_range}()},
\code{\link{cols_merge_uncert}()},
\code{\link{cols_merge}()},
\code{\link{cols_move_to_end}()},
\code{\link{cols_move_to_start}()},
\code{\link{cols_unhide}()},
\code{\link{cols_width}()}
}
\concept{column modification functions}
