% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vec.R
\name{vec_fmt_date}
\alias{vec_fmt_date}
\title{Format a vector as date values}
\usage{
vec_fmt_date(
  x,
  date_style = 2,
  pattern = "{x}",
  output = c("auto", "plain", "html", "latex", "rtf", "word")
)
}
\arguments{
\item{x}{A numeric vector.}

\item{date_style}{The date style to use. Supply a number (from \code{1} to \code{14})
that corresponds to the preferred date style, or, provide a named date
style (\code{"wday_month_day_year"}, \code{"m_day_year"}, \code{"year.mn.day"}, etc.). Use
\code{\link[=info_date_style]{info_date_style()}} to see the different numbered and named date presets.}

\item{pattern}{A formatting pattern that allows for decoration of the
formatted value. The value itself is represented by \code{{x}} and all other
characters are taken to be string literals.}

\item{output}{The output style of the resulting character vector. This can
either be \code{"auto"} (the default), \code{"plain"}, \code{"html"}, \code{"latex"}, \code{"rtf"},
or \code{"word"}. In \strong{knitr} rendering (i.e., Quarto or R Markdown), the
\code{"auto"} option will choose the correct \code{output} value}
}
\value{
A character vector.
}
\description{
Format vector values to date values using one of fourteen presets. Input can
be in the form of \code{POSIXt} (i.e., date-times), the \code{Date} type, or
\code{character} (must be in the ISO 8601 form of \verb{YYYY-MM-DD HH:MM:SS} or
\code{YYYY-MM-DD}).

We can simply apply a preset date style to format the dates. The following
date styles are available for use (all using the input date of \code{2000-02-29}
in the example output dates):
\enumerate{
\item \code{"iso"}: \code{2000-02-29}
\item \code{"wday_month_day_year"}: \verb{Tuesday, February 29, 2000}
\item \code{"wd_m_day_year"}: \verb{Tue, Feb 29, 2000}
\item \code{"wday_day_month_year"}: \verb{Tuesday 29 February 2000}
\item \code{"month_day_year"}: \verb{February 29, 2000}
\item \code{"m_day_year"}: \verb{Feb 29, 2000}
\item \code{"day_m_year"}: \verb{29 Feb 2000}
\item \code{"day_month_year"}: \verb{29 February 2000}
\item \code{"day_month"}: \verb{29 February}
\item \code{"year"}: \code{2000}
\item \code{"month"}: \code{February}
\item \code{"day"}: \code{29}
\item \code{"year.mn.day"}: \code{2000/02/29}
\item \code{"y.mn.day"}: \code{00/02/29}
}

We can use the \code{\link[=info_date_style]{info_date_style()}} function for a useful reference on all of
the possible inputs to \code{date_style}.
}
\section{Examples}{


Let's create a character vector of dates in the ISO-8601 format for the next
few examples:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{str_vals <- c("2022-06-13", "2019-01-25", "2015-03-23", NA)
}\if{html}{\out{</div>}}

Using \code{vec_fmt_date()} with the default options will create a character
vector of formatted dates. Any \code{NA} values remain as \code{NA} values. The
rendering context will be autodetected unless specified in the \code{output}
argument (here, it is of the \code{"plain"} output type).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_date(str_vals)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "Monday, June 13, 2022" "Friday, January 25, 2019"
#> [3] "Monday, March 23, 2015" NA
}\if{html}{\out{</div>}}

We can change the formatting style by choosing a number from \code{1} to \code{14}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_date(str_vals, date_style = 6)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "Jun 13, 2022" "Jan 25, 2019" "Mar 23, 2015" NA
}\if{html}{\out{</div>}}

We can always use \code{\link[=info_date_style]{info_date_style()}} to call up an info table that serves as
a handy reference to all of the date styles.

As a last example, one can wrap the date values in a pattern with the
\code{pattern} argument. Note here that \code{NA} values won't have the pattern
applied.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_date(str_vals, pattern = "Date: \{x\}")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "Date: Monday, June 13, 2022" "Date: Friday, January 25, 2019"
#> [3] "Date: Monday, March 23, 2015" NA
}\if{html}{\out{</div>}}
}

\section{Function ID}{

14-10
}

\seealso{
Other vector formatting functions: 
\code{\link{vec_fmt_bytes}()},
\code{\link{vec_fmt_currency}()},
\code{\link{vec_fmt_datetime}()},
\code{\link{vec_fmt_duration}()},
\code{\link{vec_fmt_engineering}()},
\code{\link{vec_fmt_fraction}()},
\code{\link{vec_fmt_integer}()},
\code{\link{vec_fmt_markdown}()},
\code{\link{vec_fmt_number}()},
\code{\link{vec_fmt_partsper}()},
\code{\link{vec_fmt_percent}()},
\code{\link{vec_fmt_scientific}()},
\code{\link{vec_fmt_time}()}
}
\concept{vector formatting functions}
