% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt.R
\name{gt}
\alias{gt}
\title{Create a \strong{gt} table object}
\usage{
gt(
  data,
  rowname_col = "rowname",
  groupname_col = dplyr::group_vars(data),
  caption = NULL,
  rownames_to_stub = FALSE,
  auto_align = TRUE,
  id = NULL,
  locale = NULL,
  row_group.sep = getOption("gt.row_group.sep", " - ")
)
}
\arguments{
\item{data}{A \code{data.frame} object or a tibble.}

\item{rowname_col}{The column name in the input \code{data} table to use as row
captions to be placed in the display table stub. If the \code{rownames_to_stub}
option is \code{TRUE} then any column name provided to \code{rowname_col} will be
ignored.}

\item{groupname_col}{The column name in the input \code{data} table to use as
group labels for generation of stub row groups. If the input \code{data} table
has the \code{grouped_df} class (through use of the \code{\link[dplyr:group_by]{dplyr::group_by()}} function
or associated \verb{group_by*()} functions) then any input here is ignored.}

\item{caption}{An optional table caption to use for cross-referencing
in R Markdown documents and \strong{bookdown} book projects.}

\item{rownames_to_stub}{An option to take rownames from the input \code{data}
table as row captions in the display table stub.}

\item{auto_align}{Optionally have column data be aligned depending on the
content contained in each column of the input \code{data}. Internally, this
calls \code{cols_align(align = "auto")} for all columns.}

\item{id}{The table ID. By default, with \code{NULL}, this will be a random,
ten-letter ID as generated by using the \code{\link[=random_id]{random_id()}} function. A custom
table ID can be used with any single-length character vector.}

\item{locale}{An optional locale ID that can be set as the default locale for
all functions that take a \code{locale} argument. Examples of valid locales
include \code{"en_US"} for English (United States) and \code{"fr_FR"} for French
(France). Refer to the information provided by the \code{\link[=info_locales]{info_locales()}} to
determine which locales are supported.}

\item{row_group.sep}{The separator to use between consecutive group names (a
possibility when providing \code{data} as a \code{grouped_df} with multiple groups)
in the displayed stub row group label.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt()} function creates a \strong{gt} table object when provided with table
data. Using this function is the first step in a typical \strong{gt} workflow.
Once we have the \strong{gt} table object, we can perform styling transformations
before rendering to a display table of various formats.
}
\details{
There are a few data ingest options we can consider at this stage. We can
choose to create a table stub with rowname captions using the \code{rowname_col}
argument. Further to this, stub row groups can be created with the
\code{groupname_col}. Both arguments take the name of a column in the input table
data. Typically, the data in the \code{groupname_col} will consist of categories
of data in a table and the data in the \code{rowname_col} are unique labels
(perhaps unique across the entire table or unique within groups).

Row groups can also be created by passing a \code{grouped_df} to \code{gt()} by using
the \code{\link[dplyr:group_by]{dplyr::group_by()}} function on the table data. In this way, two or more
columns of categorical data can be used to make row groups. The
\code{row_group.sep} argument allows for control in how the row group label will
appear in the display table.
}
\section{Examples}{


Create a \strong{gt} table object using the \code{\link{exibble}} dataset. Use the \code{row} and
\code{group} columns to add a stub and row groups via the \code{rowname_col} and
\code{groupname_col} arguments.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tab_1 <-
  exibble \%>\%
  gt(
    rowname_col = "row",
    groupname_col = "group"
  )

tab_1
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_gt_1.png" alt="This image of a table was generated from the first code example in the `gt()` help file." style="width:100\%;">
}}

The resulting \strong{gt} table object can be used in transformations with a
variety of \verb{tab_*()}, \verb{fmt_*()}, \verb{cols_*()}, and even more functions
available in the package.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tab_1 \%>\%
  tab_header(
    title = "Table Title",
    subtitle = "Subtitle"
  ) \%>\%
  fmt_number(
    columns = num,
    decimals = 2
  ) \%>\%
  cols_label(num = "number")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_gt_2.png" alt="This image of a table was generated from the second code example in the `gt()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

1-1
}

\seealso{
Other table creation functions: 
\code{\link{gt_preview}()}
}
\concept{table creation functions}
