% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vec.R
\name{vec_fmt_time}
\alias{vec_fmt_time}
\title{Format a vector as time values}
\usage{
vec_fmt_time(
  x,
  time_style = 2,
  pattern = "{x}",
  output = c("auto", "plain", "html", "latex", "rtf", "word")
)
}
\arguments{
\item{x}{A numeric vector.}

\item{time_style}{The time style to use. Supply a number (from \code{1} to \code{5})
that corresponds to the preferred time style, or, provide a named time
style (\code{"hms"}, \code{"hms_p"}, \code{"h_p"}, etc.). Use \code{\link[=info_time_style]{info_time_style()}} to see
the different numbered and named time presets.}

\item{pattern}{A formatting pattern that allows for decoration of the
formatted value. The value itself is represented by \code{{x}} and all other
characters are taken to be string literals.}

\item{output}{The output style of the resulting character vector. This can
either be \code{"auto"} (the default), \code{"plain"}, \code{"html"}, \code{"latex"}, \code{"rtf"},
or \code{"word"}. In \strong{knitr} rendering (i.e., Quarto or R Markdown), the
\code{"auto"} option will choose the correct \code{output} value}
}
\value{
A character vector.
}
\description{
Format vector values to time values using one of five presets. Input can be
in the form of \code{POSIXt} (i.e., date-times), \code{character} (must be in the ISO
8601 forms of \code{HH:MM:SS} or \verb{YYYY-MM-DD HH:MM:SS}), or \code{Date} (which always
results in the formatting of \code{00:00:00}).

We can simply apply a preset time style to format the times. The following
time styles are available for use (all using the input time of \code{14:35:00} in
the example output times):
\enumerate{
\item \code{"hms"}: \code{14:35:00}
\item \code{"hm"}: \code{14:35}
\item \code{"hms_p"}: \verb{2:35:00 PM}
\item \code{"hm_p"}: \verb{2:35 PM}
\item \code{"h_p"}: \verb{2 PM}
}

We can use the \code{\link[=info_time_style]{info_time_style()}} function for a useful reference on all of
the possible inputs to \code{time_style}.
}
\section{Examples}{


Let's create a character vector of datetime values in the ISO-8601 format
for the next few examples:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{str_vals <- c("2022-06-13 18:36", "2019-01-25 01:08", NA)
}\if{html}{\out{</div>}}

Using \code{vec_fmt_time()} with the default options will create a character
vector of formatted times. Any \code{NA} values remain as \code{NA} values. The
rendering context will be autodetected unless specified in the \code{output}
argument (here, it is of the \code{"plain"} output type).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_time(str_vals)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "18:36" "01:08" NA
}\if{html}{\out{</div>}}

We can change the formatting style by choosing a number from \code{1} to \code{5}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_time(str_vals, time_style = 4)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "6:36 PM" "1:08 AM" NA
}\if{html}{\out{</div>}}

We can always use \code{\link[=info_time_style]{info_time_style()}} to call up an info table that serves as
a handy reference to all of the time styles.

As a last example, one can wrap the time values in a pattern with the
\code{pattern} argument. Note here that \code{NA} values won't have the pattern
applied.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_time(str_vals, time_style = 4, pattern = "Time: \{x\}")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "Time: 6:36 PM" "Time: 1:08 AM" NA
}\if{html}{\out{</div>}}
}

\section{Function ID}{

14-11
}

\seealso{
Other vector formatting functions: 
\code{\link{vec_fmt_bytes}()},
\code{\link{vec_fmt_currency}()},
\code{\link{vec_fmt_datetime}()},
\code{\link{vec_fmt_date}()},
\code{\link{vec_fmt_duration}()},
\code{\link{vec_fmt_engineering}()},
\code{\link{vec_fmt_fraction}()},
\code{\link{vec_fmt_integer}()},
\code{\link{vec_fmt_markdown}()},
\code{\link{vec_fmt_number}()},
\code{\link{vec_fmt_partsper}()},
\code{\link{vec_fmt_percent}()},
\code{\link{vec_fmt_scientific}()}
}
\concept{vector formatting functions}
