% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_preview.R
\name{gt_preview}
\alias{gt_preview}
\title{Preview a \strong{gt} table object}
\usage{
gt_preview(data, top_n = 5, bottom_n = 1, incl_rownums = TRUE)
}
\arguments{
\item{data}{A \code{data.frame} object or a tibble.}

\item{top_n}{This value will be used as the number of rows from the top of
the table to display. The default, \code{5}, will show the first five rows of
the table.}

\item{bottom_n}{The value will be used as the number of rows from the bottom
of the table to display. The default, \code{1}, will show the final row of the
table.}

\item{incl_rownums}{An option to include the row numbers for \code{data} in the
table stub. By default, this is \code{TRUE}.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Sometimes you may want to see just a small portion of your input data. We can
use \code{gt_preview()} in place of \code{\link[=gt]{gt()}} to get the first x rows of data and the
last y rows of data (which can be set by the \code{top_n} and \code{bottom_n}
arguments). It's not advised to use additional \strong{gt} functions to further
modify the output of \code{gt_preview()}. Furthermore, you cannot pass a \strong{gt}
object to \code{gt_preview()}.
}
\details{
Any grouped data or magic columns such as \code{rowname} and \code{groupname} will be
ignored by \code{gt_preview()} and, as such, one cannot add a stub or group rows
in the output table. By default, the output table will include row numbers in
a stub (including a range of row numbers for the omitted rows). This row
numbering option can be deactivated by setting \code{incl_rownums} to \code{FALSE}.
}
\section{Figures}{

\if{html}{\figure{man_gt_preview_1.png}{options: width=100\%}}
}

\section{Function ID}{

1-2
}

\examples{
# Use `gtcars` to create a gt table
# preview (with only a few of its
# columns); you'll see the first five
# rows and the last row
tab_1 <-
  gtcars \%>\%
  dplyr::select(mfr, model, year) \%>\%
  gt_preview()

}
\seealso{
Other Create Table: 
\code{\link{gt}()}
}
\concept{Create Table}
