% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{cells_column_spanners}
\alias{cells_column_spanners}
\title{Location helper for targeting the column spanners}
\usage{
cells_column_spanners(spanners)
}
\arguments{
\item{spanners}{The names of the spanners that are to be targeted.}
}
\value{
A list object with the classes \code{cells_column_spanners} and
\code{location_cells}.
}
\description{
The \code{cells_column_spanners()} function is used to target the cells that
contain the table column spanners. This is useful when applying a footnote
with \code{\link[=tab_footnote]{tab_footnote()}} or adding custom style with \code{\link[=tab_style]{tab_style()}}. The function
is expressly used in each of those functions' \code{locations} argument.
}
\details{
When using any of the location helper functions with an appropriate function
that has a \code{locations} argument, multiple locations can be targeted by
enclosing several \verb{cells_*()} helper functions in a \code{list()}. The following
helper functions can be used to target cells (roughly in order from the top
to the bottom of a table):
\itemize{
\item \code{\link[=cells_title]{cells_title()}}: targets the table title or the table subtitle
depending on the value given to the \code{groups} argument (\code{"title"} or
\code{"subtitle"}).
\item \code{\link[=cells_stubhead]{cells_stubhead()}}: targets the stubhead location, a cell of which is
only available when there is a stub; a label in that location can be created
by using the \code{\link[=tab_stubhead]{tab_stubhead()}} function.
\item \code{\link[=cells_column_spanners]{cells_column_spanners()}}: targets the spanner column labels, which
appear above the column labels.
\item \code{\link[=cells_column_labels]{cells_column_labels()}}: targets the column labels.
\item \code{\link[=cells_row_groups]{cells_row_groups()}}: targets the row group labels in any available row
groups using the \code{groups} argument.
\item \code{\link[=cells_stub]{cells_stub()}}: targets row labels in the table stub using the \code{rows}
argument.
\item \code{\link[=cells_body]{cells_body()}}: targets data cells in the table body using
intersections of \code{columns} and \code{rows}.
\item \code{\link[=cells_summary]{cells_summary()}}: targets summary cells in the table body using the
\code{groups} argument and intersections of \code{columns} and \code{rows}.
\item \code{\link[=cells_grand_summary]{cells_grand_summary()}}: targets cells of the table's grand summary
using intersections of \code{columns} and \code{rows}
}
}
\section{Figures}{

\if{html}{\figure{man_cells_column_spanners_1.png}{options: width=100\%}}
}

\section{Function ID}{

7-7
}

\examples{
# Use `exibble` to create a gt table; add a
# spanner column label over three column
# labels and then use `tab_style()` to make
# the spanner label text bold
tab_1 <-
  exibble \%>\%
  dplyr::select(-fctr, -currency, -group) \%>\%
  gt(rowname_col = "row") \%>\%
  tab_spanner(
    label = "dates and times",
    columns = vars(date, time, datetime)
  ) \%>\%
  tab_style(
    style = cell_text(weight = "bold"),
    locations = cells_column_spanners(spanners = "dates and times")
  )

}
\seealso{
Other Helper Functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_stub}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()}
}
\concept{Helper Functions}
