% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_create_modify.R
\name{tab_caption}
\alias{tab_caption}
\title{Add a table caption}
\usage{
tab_caption(data, caption)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{caption}{\emph{Table caption text}

\verb{scalar<character>} // \strong{required}

The table caption to use for cross-referencing in R Markdown, Quarto, or
\strong{bookdown}.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Add a caption to a \strong{gt} table, which is handled specially for a table
within an R Markdown, Quarto, or \strong{bookdown} context. The addition of
captions makes tables cross-referencing across the containing document. The
caption location (i.e., top, bottom, margin) is handled at the document level
in each of these system.
}
\section{Examples}{


With three columns from the \code{\link{gtcars}} dataset, let's create a \strong{gt} table.
First, we'll add a header part with \code{\link[=tab_header]{tab_header()}}. After that, a caption is
added with \code{tab_caption()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gtcars |>
  dplyr::select(mfr, model, msrp) |>
  dplyr::slice(1:5) |>
  gt() |>
  tab_header(
    title = md("Data listing from **gtcars**"),
    subtitle = md("`gtcars` is an R dataset")
  ) |>
  tab_caption(caption = md("**gt** table example."))
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_tab_caption_1.png" alt="This image of a table was generated from the first code example in the `tab_caption()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

2-9
}

\section{Function Introduced}{

\code{v0.8.0} (November 16, 2022)
}

\seealso{
Other part creation/modification functions: 
\code{\link{tab_footnote}()},
\code{\link{tab_header}()},
\code{\link{tab_info}()},
\code{\link{tab_options}()},
\code{\link{tab_row_group}()},
\code{\link{tab_source_note}()},
\code{\link{tab_spanner}()},
\code{\link{tab_spanner_delim}()},
\code{\link{tab_stub_indent}()},
\code{\link{tab_stubhead}()},
\code{\link{tab_style}()},
\code{\link{tab_style_body}()}
}
\concept{part creation/modification functions}
