% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{extract_cells}
\alias{extract_cells}
\title{Extract a vector of formatted cells from a \strong{gt} object}
\usage{
extract_cells(
  data,
  columns,
  rows = everything(),
  output = c("auto", "plain", "html", "latex", "rtf", "word")
)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{columns}{\emph{Columns to target}

\verb{<column-targeting expression>} // \emph{default:} \code{everything()}

Can either be a series of column names provided in \code{c()}, a vector of
column indices, or a select helper function (e.g. \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=num_range]{num_range()}} and \code{\link[=everything]{everything()}}).}

\item{rows}{\emph{Rows to target}

\verb{<row-targeting expression>} // \emph{default:} \code{everything()}

In conjunction with \code{columns}, we can specify which of their rows should
form a constraint for extraction. The default \code{\link[=everything]{everything()}} results in all
rows in \code{columns} being formatted. Alternatively, we can supply a vector of
row IDs within \code{c()}, a vector of row indices, or a select helper function
(e.g. \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}). We can also use expressions to filter
down to the rows we need (e.g., \verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{output}{\emph{Output format}

\verb{singl-kw:[auto|plain|html|latex|rtf|word]} // \emph{default:} \code{"auto"}

The output style of the resulting character vector. This can either be
\code{"auto"} (the default), \code{"plain"}, \code{"html"}, \code{"latex"}, \code{"rtf"}, or
\code{"word"}. In \strong{knitr} rendering (i.e., Quarto or R Markdown), the \code{"auto"}
option will choose the correct \code{output} value}
}
\value{
A vector of cell data extracted from a \strong{gt} table.
}
\description{
Get a vector of cell data from a \code{gt_tbl} object. The output vector will have
cell data formatted in the same way as the table.
}
\section{Examples}{


Let's create a \strong{gt} table with the \code{\link{exibble}} dataset to use in the next
few examples:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gt_tbl <- gt(exibble, rowname_col = "row", groupname_col = "group")
}\if{html}{\out{</div>}}

We can extract a cell from the table with the \code{extract_cells()} function.
This is done by providing a column and a row intersection:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{extract_cells(gt_tbl, columns = num, row = 1)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "1.111e-01"
}\if{html}{\out{</div>}}

Multiple cells can be extracted. Let's get the first four cells from the
\code{char} column.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{extract_cells(gt_tbl, columns = char, rows = 1:4)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "apricot" "banana" "coconut" "durian"
}\if{html}{\out{</div>}}

We can format cells and expect that the formatting is fully retained after
extraction.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gt_tbl |>
  fmt_number(columns = num, decimals = 2) |>
  extract_cells(columns = num, rows = 1)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "0.11"
}\if{html}{\out{</div>}}
}

\section{Function ID}{

13-9
}

\section{Function Introduced}{

\code{v0.8.0} (November 16, 2022)
}

\seealso{
Other table export functions: 
\code{\link{as_gtable}()},
\code{\link{as_latex}()},
\code{\link{as_raw_html}()},
\code{\link{as_rtf}()},
\code{\link{as_word}()},
\code{\link{extract_body}()},
\code{\link{extract_summary}()},
\code{\link{gtsave}()}
}
\concept{table export functions}
