% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{stub}
\alias{stub}
\title{Select helper for targeting the stub column}
\usage{
stub()
}
\value{
A character vector of class \code{"stub_column"}.
}
\description{
Should you need to target only the stub column for formatting or other
operations, the \code{stub()} select helper can be used. This obviates the need
to use the name of the column that was selected as the stub column.
}
\section{Examples}{


Create a tibble that has a \code{row} column (values from \code{1} to \code{6}), a \code{group}
column, and a \code{vals} column (containing the same values as in \code{row}).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl <-
  dplyr::tibble(
    row = 1:6,
    group = c(rep("Group A", 3), rep("Group B", 3)),
    vals = 1:6
  )
}\if{html}{\out{</div>}}

Create a \strong{gt} table with a two-column stub (incorporating the \code{row} and
\code{group} columns in that). Format the row labels of the stub with
\code{\link[=fmt_roman]{fmt_roman()}} to obtain Roman numerals in the stub; we're selecting the stub
column here with the \code{stub()} select helper.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl |>
  gt(rowname_col = "row", groupname_col = "group") |>
  fmt_roman(columns = stub()) |>
  tab_options(row_group.as_column = TRUE)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_stub_1.png" alt="This image of a table was generated from the first code example in the `stub()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-10
}

\section{Function Introduced}{

\code{v0.8.0} (November 16, 2022)
}

\seealso{
Other helper functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_stub}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{define_units}()},
\code{\link{escape_latex}()},
\code{\link{from_column}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{nanoplot_options}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()},
\code{\link{system_fonts}()}
}
\concept{helper functions}
