% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{gt_output}
\alias{gt_output}
\title{Create a \strong{gt} display table output element for Shiny}
\usage{
gt_output(outputId)
}
\arguments{
\item{outputId}{\emph{Shiny output ID}

\verb{scalar<character>} // \strong{required}

An output variable from which to read the table.}
}
\value{
An object of class \code{shiny.tag}.
}
\description{
Using \code{gt_output()} we can render a reactive \strong{gt} table, a process
initiated by using the \code{\link[=render_gt]{render_gt()}} function in the \code{server} component of a
Shiny app. The \code{gt_output()} call is to be used in the Shiny \code{ui} component,
the position and context wherein this call is made determines the where the
\strong{gt} table is rendered on the app page. It's important to note that the
ID given during the \code{\link[=render_gt]{render_gt()}} call is needed as the \code{outputId} in
\code{gt_output()} (e.g., \strong{server}: \verb{output$<id> <- render_gt(...)}; \strong{ui}:
\verb{gt_output(outputId = "<id>"}).

We need to ensure that we have the \strong{shiny} package installed first. This
is easily by using \code{install.packages("shiny")}. More information on creating
Shiny apps can be found on the \href{https://shiny.posit.co}{Shiny website}.
}
\section{Examples}{


Here is a Shiny app (contained within a single file) that (1) prepares a
\strong{gt} table, (2) sets up the \code{ui} with \code{gt_output()}, and (3) sets up the
\code{server} with a \code{\link[=render_gt]{render_gt()}} that uses the \code{gt_tbl} object as the input
expression.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(shiny)

gt_tbl <-
  gtcars |>
  gt() |>
  fmt_currency(columns = msrp, decimals = 0) |>
  cols_hide(columns = -c(mfr, model, year, mpg_c, msrp)) |>
  cols_label_with(columns = everything(), fn = toupper) |>
  data_color(columns = msrp, method = "numeric", palette = "viridis") |>
  sub_missing() |>
  opt_interactive(use_compact_mode = TRUE)

ui <- fluidPage(
  gt_output(outputId = "table")
)

server <- function(input, output, session) \{
  output$table <- render_gt(expr = gt_tbl)
\}

shinyApp(ui = ui, server = server)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_render_gt_1.png" alt="This image of a table was generated from the first code example in the `render_gt()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

12-2
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other Shiny functions: 
\code{\link{render_gt}()}
}
\concept{Shiny functions}
