% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt.R
\name{gt}
\alias{gt}
\title{Create a \strong{gt} table object}
\usage{
gt(
  data,
  rowname_col = "rowname",
  groupname_col = dplyr::group_vars(data),
  process_md = FALSE,
  caption = NULL,
  rownames_to_stub = FALSE,
  row_group_as_column = FALSE,
  auto_align = TRUE,
  id = NULL,
  locale = NULL,
  row_group.sep = getOption("gt.row_group.sep", " - ")
)
}
\arguments{
\item{data}{\emph{Input data table}

\verb{obj:<data.frame>|obj:<tbl_df>} // \strong{required}

A \code{data.frame} object or a tibble (\code{tbl_df}).}

\item{rowname_col}{\emph{Column for row names/labels from \code{data}}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The column name in the input \code{data} table to use as row labels to be placed
in the table stub. If the \code{rownames_to_stub} option is \code{TRUE} then any
column name provided to \code{rowname_col} will be ignored.}

\item{groupname_col}{\emph{Column for group names/labels from \code{data}}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The column name in the input \code{data} table to use as group labels for
generation of stub row groups. If the input \code{data} table has the
\code{grouped_df} class (through use of the \code{\link[dplyr:group_by]{dplyr::group_by()}} function or
associated \verb{group_by*()} functions) then any input here is ignored.}

\item{process_md}{\emph{Process Markdown in \code{rowname_col} and \code{groupname_col}}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

Should the contents of the \code{rowname_col} and \code{groupname_col} be interpreted
as Markdown? By default this won't happen.}

\item{caption}{\emph{Table caption text}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional table caption to use for cross-referencing in R Markdown,
Quarto, or \strong{bookdown}.}

\item{rownames_to_stub}{\emph{Use data frame row labels in the stub}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

An option to take rownames from the input \code{data} table (should they be
available) as row labels in the display table stub.}

\item{row_group_as_column}{\emph{Mode for displaying row group labels in the stub}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

An option that alters the display of row group labels. By default this is
\code{FALSE} and row group labels will appear in dedicated rows above their
respective groups of rows. If \code{TRUE} row group labels will occupy a
secondary column in the table stub.}

\item{auto_align}{\emph{Automatic alignment of column values and labels}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

Optionally have column data be aligned depending on the content contained
in each column of the input \code{data}. Internally, this calls
\code{cols_align(align = "auto")} for all columns.}

\item{id}{\emph{The table ID}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

By default (with \code{NULL}) this will be a random, ten-letter ID as generated
by using the \code{\link[=random_id]{random_id()}} function. A custom table ID can be used be
providing a single-length character vector.}

\item{locale}{\emph{Locale identifier}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional locale identifier that can be set as the default locale for all
functions that take a \code{locale} argument. Examples include \code{"en"} for
English (United States) and \code{"fr"} for French (France). We can use the
\code{\link[=info_locales]{info_locales()}} function as a useful reference for all of the locales that
are supported.}

\item{row_group.sep}{\emph{Separator text for multiple row group labels}

\verb{scalar<character>} // \emph{default:} \code{getOption("gt.row_group.sep", " - ")}

The separator to use between consecutive group names (a possibility when
providing \code{data} as a \code{grouped_df} with multiple groups) in the displayed
row group label.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt()} function creates a \strong{gt} table object when provided with table
data. Using this function is the first step in a typical \strong{gt} workflow.
Once we have the \strong{gt} table object, we can perform styling transformations
before rendering to a display table of various formats.
}
\details{
There are a few data ingest options we can consider at this stage. We can
choose to create a table stub with rowname captions using the \code{rowname_col}
argument. Further to this, stub row groups can be created with the
\code{groupname_col}. Both arguments take the name of a column in the input table
data. Typically, the data in the \code{groupname_col} will consist of categories
of data in a table and the data in the \code{rowname_col} are unique labels
(perhaps unique across the entire table or unique within groups).

Row groups can also be created by passing a \code{grouped_df} to \code{gt()} by using
the \code{\link[dplyr:group_by]{dplyr::group_by()}} function on the table data. In this way, two or more
columns of categorical data can be used to make row groups. The
\code{row_group.sep} argument allows for control in how the row group label will
appear in the display table.
}
\section{Examples}{


Let's use the \code{\link{exibble}} dataset for the next few examples, we'll learn how
to make simple \strong{gt} tables with the \code{gt()} function. The most basic thing
to do is to just use \code{gt()} with the dataset as the input.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |> gt()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_gt_1.png" alt="This image of a table was generated from the first code example in the `gt()` help file." style="width:100\%;">
}}

This dataset has the \code{row} and \code{group} columns. The former contains unique
values that are ideal for labeling rows, and this often happens in what is
called the 'stub' (a reserved area that serves to label rows). With the
\code{gt()} function, we can immediately place the contents of the \code{row} column
into the stub column. To do this, we use the \code{rowname_col} argument with the
name of the column to use in quotes.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |> gt(rowname_col = "row")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_gt_2.png" alt="This image of a table was generated from the second code example in the `gt()` help file." style="width:100\%;">
}}

This sets up a table with a stub, the row labels are placed within the stub
column, and a vertical dividing line has been placed on the right-hand side.

The \code{group} column can be used to divide the rows into discrete groups.
Within that column, we see repetitions of the values \code{grp_a} and \code{grp_b}.
These serve both as ID values and the initial label for the groups. With the
\code{groupname_col} argument in \code{gt()}, we can set up the row groups immediately
upon creation of the table.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  gt(
    rowname_col = "row",
    groupname_col = "group"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_gt_3.png" alt="This image of a table was generated from the third code example in the `gt()` help file." style="width:100\%;">
}}

If you'd rather perform the set up of row groups later (i.e., not in the
\code{gt()} call), this is possible with use of the \code{\link[=tab_row_group]{tab_row_group()}} function
(and \code{\link[=row_group_order]{row_group_order()}} can help with the arrangement of row groups).

One more thing to consider with row groups is their layout. By default, row
group labels reside in separate rows the appear above the group. However,
we can use the \code{row_group_as_column = TRUE} option to put the row group
labels within a secondary column within the table stub.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  gt(
    rowname_col = "row",
    groupname_col = "group",
    row_group_as_column = TRUE
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_gt_4.png" alt="This image of a table was generated from the fourth code example in the `gt()` help file." style="width:100\%;">
}}

This could be done later if need be, and using
\code{tab_options(row_group.as_column = TRUE)} would be the way to do it outside
of the \code{gt()} call.

Some datasets have rownames built in; \code{mtcars} famously has the car model
names as the rownames. To use those rownames as row labels in the stub, the
\code{rownames_to_stub = TRUE} option will prove to be useful.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{head(mtcars, 10) |> gt(rownames_to_stub = TRUE)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_gt_5.png" alt="This image of a table was generated from the fifth code example in the `gt()` help file." style="width:100\%;">
}}

By default, values in the body of a \strong{gt} table (and their column labels)
are automatically aligned. The alignment is governed by the types of values
in a column. If you'd like to disable this form of auto-alignment, the
\code{auto_align = FALSE} option can be taken.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |> gt(rowname_col = "row", auto_align = FALSE)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_gt_6.png" alt="This image of a table was generated from the sixth code example in the `gt()` help file." style="width:100\%;">
}}

What you'll get from that is center-alignment of all table body values and
all column labels. Note that row labels in the the stub are still
left-aligned; and \code{auto_align} has no effect on alignment within the table
stub.

However which way you generate the initial \strong{gt} table object, you can use
it with a huge variety of functions in the package to further customize the
presentation. Formatting body cells is commonly done with the family of
formatting functions (e.g., \code{\link[=fmt_number]{fmt_number()}}, \code{\link[=fmt_date]{fmt_date()}}, etc.). The package
supports formatting with internationalization ('i18n' features) and so
locale-aware functions come with a \code{locale} argument. To avoid having to use
that argument repeatedly, the \code{gt()} function has its own \code{locale} argument.
Setting a locale in that will make it available globally. Here's an example
of how that works in practice when setting \code{locale = "fr"} in \code{gt()} and
using formatting functions:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  gt(
    rowname_col = "row",
    groupname_col = "group",
    locale = "fr"
  ) |>
  fmt_number() |>
  fmt_date(
    columns = date,
    date_style = "yMEd"
  ) |>
  fmt_datetime(
    columns = datetime,
    format = "EEEE, MMMM d, y",
    locale = "en"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_gt_7.png" alt="This image of a table was generated from the seventh code example in the `gt()` help file." style="width:100\%;">
}}

In this example, the \code{\link[=fmt_number]{fmt_number()}} and \code{\link[=fmt_date]{fmt_date()}} functions understand
that the locale for this table is \code{"fr"} (French), so the appropriate
formatting for that locale is apparent in the \code{num}, \code{currency}, and \code{date}
columns. However in the \code{\link[=fmt_datetime]{fmt_datetime()}} call, we explicitly use the \code{"en"}
(English) locale. This overrides the \code{"fr"} default set for this table and
the end result is dates formatted with the English locale in the \code{datetime}
column.
}

\section{Function ID}{

1-1
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other table creation functions: 
\code{\link{gt_preview}()}
}
\concept{table creation functions}
