% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_CT_first_derivatives}
\alias{gsw_CT_first_derivatives}
\title{First Derivatives of Conservative Temperature}
\usage{
gsw_CT_first_derivatives(SA, pt)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{pt}{potential temperature (ITS-90) [ degC ]}
}
\value{
A list containing \code{CT_SA} [ K/(g/kg) ], the derivative of
Conservative Temperature with respect to Absolute Salinity,
and \code{CT_pt} [ unitless ], the derivative of
Conservative Temperature with respect to potential temperature.
}
\description{
First Derivatives of Conservative Temperature
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
pt <- c(28.7832, 28.4209, 22.7850, 10.2305,  6.8292,  4.3245)
r <- gsw_CT_first_derivatives(SA, pt)
expect_equal(r$CT_SA, c(-0.041981092877806, -0.041558140199508, -0.034739209004865,
                      -0.018711103772892, -0.014075941811725, -0.010571716552295))
expect_equal(r$CT_pt, c(1.002814937296636, 1.002554817053239, 1.001645140295163,
                      1.000003771100520, 0.999716359504731, 0.999474326580093))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_CT_first_derivatives.html}
}
