% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_gibbs_ice}
\alias{gsw_gibbs_ice}
\title{Gibbs Energy of Ice, and its Derivatives}
\usage{
gsw_gibbs_ice(nt, np, t, p = 0)
}
\arguments{
\item{nt}{An integer, the order of the \code{t} derivative. Must be 0, 1, or 2.}

\item{np}{An integer, the order of the \code{p} derivative. Must be 0, 1, or 2.}

\item{t}{in-situ temperature (ITS-90) [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
Gibbs energy [ J/kg ] if \code{ns}=\code{nt}=\code{np}=0. Derivative of energy
with respect to \code{t} [ J/kg/(degC)^nt ] if \code{nt} is nonzero,
etc. Note that derivatives with respect to pressure are in units with Pa, not dbar.
}
\description{
Gibbs Energy of Ice, and its Derivatives
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\section{Caution}{

The TEOS-10 webpage for \code{gsw_gibbs_ice} does not provide test values, so
the present R version should be considered untested.
}

\examples{
library(gsw)
p <- seq(0, 100, 1)
t <- rep(-5, length(p))
## Check the derivative wrt pressure. Note the unit change
E <- gsw_gibbs_ice(0, 0, t, p)
# Estimate derivative from linear fit (try plotting: it is very linear)
m <- lm(E ~ p)
print(summary(m))
plot(p, E)
abline(m)
dEdp1 <- coef(m)[2]
# Calculate derivative ... note we multiply by 1e4 to get from 1/Pa to 1/dbar
dEdp2 <- 1e4 * gsw_gibbs_ice(0, 1, t[1], p[1])
## Ratio
dEdp1 / dEdp2
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_gibbs_ice.html}
}
