% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_entropy_from_t}
\alias{gsw_entropy_from_t}
\title{Specific entropy as a function of in-situ temperature and pressure}
\usage{
gsw_entropy_from_t(SA, t, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{t}{in-situ temperature (ITS-90) [ deg C ]}

\item{p}{sea pressure [ dbar ]}
}
\value{
specific entropy [ J/(kg*K) ]
}
\description{
Calculates specific entropy given Absolute Salinity, in-situ
temperature and pressure.
}
\details{
The related function gsw_entropy_from_CT() is not provided
in the C library, although it is available in the (later-
versioned) Matlab library.
}
\examples{
gsw_entropy_from_t(34.7118, 28.7856, 10) # 400.3894252787245
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_entropy_from_t.html}
}

