% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_Nsquared}
\alias{gsw_Nsquared}
\title{Calculate Brunt Vaisala Frequency squared}
\usage{
gsw_Nsquared(SA, CT, p, latitude = 0)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ deg C ]}

\item{p}{sea pressure [ dbar ]}

\item{latitude}{latitude in decimal degrees [ -90 to 90 ]}
}
\value{
list containing N2 [ 1/s^ ] and mid-point pressure p_mid [ dbar ]
}
\description{
Calculate Brunt Vaisala Frequency squared
}
\examples{
SA <- c(34.7118, 34.8915)
CT <- c(28.8099, 28.4392)
p <- c(      10,      50)
latitude <- 4
gsw_Nsquared(SA, CT, p, latitude)$N2 # 6.0847042791371e-5
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_Nsquared.html}
}

