\name{genetic_distance}
\alias{genetic_distance}
\title{Estimate genetic distances among strata in a ,}
\usage{
  genetic_distance(x, stratum = "Population", mode)
}
\arguments{
  \item{x}{A \code{data.frame} object with
  \code{\link{locus}} columns.}

  \item{stratum}{The strata by which the genetic distances
  are estimated.  This can be an optional parameter when
  estimating distance measures calculated among indiviudals
  (default='Population').}

  \item{mode}{The particular genetic distance metric that
  you are going to use.}
}
\value{
  A \code{genetic_distance} object (also a matrix) with the
  genetic distances and a bit of additional information
  about its creation.
}
\description{
  This function is the main one used for estimating genetic
  distances among either individuals or stratum.  Given the
  large number of genetic distance metrics, some are
  recreated here, de novo, and some are estimated through
  other existing R packages.
}
\note{
  This function currently includes the following individual
  distance measures: \itemize{
  \item{AMOVA}{Inter-individual } \item{Bray}{Proportion of
  shared alleles} } This function also supports genetic
  distances based upon stratum distances.  The currently
  supported genetic distances are: \itemize{
  \item{Euclidean}{Euclidean frequency distance}
  \item{cGD}{Conditional Genetic Distance} \item{Nei}{Nei's
  corrected genetic distance (1978)} \item{Dps}{Shared
  allele distance = 1 - Ps} \item{Jaccard}{Jaccard set
  dissimilarity} }
}
\examples{
AA <- locus( c("A","A") )
AB <- locus( c("A","B") )
BB <- locus( c("B","B") )
AC <- locus( c("A","C") )
AD <- locus( c("A","D") )
BC <- locus( c("B","C") )
BD <- locus( c("B","D") )
CC <- locus( c("C","C") )
CD <- locus( c("C","D") )
DD <- locus( c("D","D") )
loci <- c(AA,AB,AC,AD,BB,BC,BD,CC,CD,DD)
pops <- c(rep("A",5), rep("B",5))
df <- data.frame( Population=pops, TPI=loci)
genetic_distance(df, mode="AMOVA")
genetic_distance(df, mode="Dps")
}
\author{
  Rodney J. Dyer \email{rjdyer@vcu.edu}
}

