% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_thrs_LLS.R
\name{cp_thrs_LLS}
\alias{cp_thrs_LLS}
\title{Compute threshold values based on Log-likelihood values}
\usage{
cp_thrs_LLS(dv, ivs, fam)
}
\arguments{
\item{dv}{numeric vector or factor of dependent variable values}

\item{ivs}{\eqn{n \times p} data.frame of independent variables (factors allowed)}

\item{fam}{character vector of length 1 storing the description of the error distribution and link function to be used in the model (see \code{\link[=cv_gspcr]{cv_gspcr()}} for the list of possible options)}
}
\value{
numeric vector of log-likelihood value from all of the univariate GLM models regressing \code{dv} on each column of \code{ivs}.
}
\description{
Produces a vector of threshold values that define active predictors.
}
\examples{
# Example inputs
dv <- mtcars[, 1]
ivs <- mtcars[, -1]
fam <- "gaussian"

# Use function
cp_thrs_LLS(dv, ivs, fam)

}
\author{
Edoardo Costantini, 2023
}
