% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls.R
\name{gsl_nls_control}
\alias{gsl_nls_control}
\title{Tunable Nonlinear Least Squares iteration parameters}
\usage{
gsl_nls_control(
  maxiter = 50,
  scale = "more",
  solver = "qr",
  fdtype = "forward",
  factor_up = 3,
  factor_down = 2,
  avmax = 0.75,
  h_df = sqrt(.Machine$double.eps),
  h_fvv = 0.02,
  xtol = sqrt(.Machine$double.eps),
  ftol = sqrt(.Machine$double.eps),
  gtol = .Machine$double.eps^(1/3)
)
}
\arguments{
\item{maxiter}{positive integer, termination occurs when the number of iterations reaches \code{maxiter}.}

\item{scale}{character, scaling method or damping strategy determining the diagonal scaling matrix D. The following options
are supported:
\itemize{
\item \code{"more"} Moré rescaling (default). This method makes the problem scale-invariant and has
been proven effective on a large class of problems.
\item \code{"levenberg"} Levenberg rescaling. This method has also proven effective on a large class of problems,
but is not scale-invariant. It may perform better for problems susceptible to \emph{parameter evaporation} (parameters going to infinity).
\item \code{"marquadt"} Marquadt rescaling. This method is scale-invariant, but it is generally
considered inferior to both the Levenberg and Moré strategies.
}}

\item{solver}{character, method used to solve the linear least squares system resulting as a subproblem in each iteration.
For large-scale problems fitted with \code{\link{gsl_nls_large}}, the Cholesky solver (\code{"cholesky"}) is always selected
and this parameter is not used. For least squares problems fitted with \code{\link{gsl_nls}} the following choices are supported:
\itemize{
\item \code{"qr"} QR decomposition of the Jacobian (default). This method will produce reliable solutions in cases
where the Jacobian is rank deficient or near-singular but does require more operations than the Cholesky method.
\item \code{"cholesky"} Cholesky decomposition of the Jacobian. This method is faster than the QR approach, however
it is susceptible to numerical instabilities if the Jacobian matrix is rank deficient or near-singular.
\item \code{"svd"} SVD decomposition of the Jacobian. This method will produce the most reliable solutions for
ill-conditioned Jacobians but is also the slowest.
}}

\item{fdtype}{character, method used to numerically approximate the Jacobian and/or second-order derivatives
when geodesic acceleration is used. Either \code{"forward"} for forward finite differencing or \code{"center"}
for centered finite differencing. For least squares problems solved with \code{\link{gsl_nls_large}}, numerical
approximation of the Jacobian matrix is not available and this parameter is only used to numerically approximate
the second-order derivatives (if geodesic acceleration is used).}

\item{factor_up}{numeric factor by which to increase the trust region radius when a search step is accepted.
Too large values may destabilize the search, too small values slow down the search, defaults to 3.}

\item{factor_down}{numeric factor by which to decrease the trust region radius when a search step is rejected.
Too large values may destabilize the search, too small values slow down the search, defaults to 2.}

\item{avmax}{numeric value, the ratio of the acceleration term to the velocity term when using geodesic acceleration to
solve the nonlinear least squares problem. Any steps with a ratio larger than \code{avmax} are rejected, defaults to 0.75.
For problems which experience difficulty converging, this threshold could be lowered.}

\item{h_df}{numeric value, the step size for approximating the Jacobian matrix with finite differences, defaults to \code{sqrt(.Machine$double.eps)}.}

\item{h_fvv}{numeric value, the step size for approximating the second directional derivative when geodesic acceleration
is used to solve the nonlinear least squares problem, defaults to 0.02. This is only used if no analytic second
directional derivative (\code{fvv}) is specified in \code{\link{gsl_nls}} or \code{\link{gsl_nls_large}}.}

\item{xtol}{numeric value, termination occurs when the relative change in parameters between iterations is \code{<= xtol}.
A general guideline for selecting the step tolerance is to choose \code{xtol = 10^(-d)} where \code{d} is the number of accurate
decimal digits desired in the parameters, defaults to \code{sqrt(.Machine$double.eps)}.}

\item{ftol}{numeric value, termination occurs when the relative change in sum of squared residuals between iterations is \code{<= ftol},
defaults to \code{sqrt(.Machine$double.eps)}.}

\item{gtol}{numeric value, termination occurs when the relative size of the gradient of the sum of squared residuals is \code{<= gtol},
indicating a local minimum, defaults to \code{.Machine$double.eps^(1/3)}}
}
\value{
A \code{list} with exactly twelve components:
\itemize{
\item maxiter
\item scale
\item solver
\item fdtype
\item factor_up
\item factor_down
\item avmax
\item h_df
\item h_fvv
\item xtol
\item ftol
\item gtol
}
with meanings as explained under 'Arguments'.
}
\description{
Allow the user to tune the characteristics of the \code{\link{gsl_nls}} and \code{\link{gsl_nls_large}}
nonlinear least squares algorithms.
}
\note{
\code{ftol} is disabled in some versions of the GSL library.
}
\examples{
## default tuning parameters
gsl_nls_control()
}
\references{
M. Galassi et al., \emph{GNU Scientific Library Reference Manual (3rd Ed.)}, ISBN 0954612078.
}
\seealso{
\code{\link[stats]{nls.control}}

\url{https://www.gnu.org/software/gsl/doc/html/nls.html#tunable-parameters}
}
