% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls-methods.R
\name{formula.gsl_nls}
\alias{formula.gsl_nls}
\title{Extract model formula}
\usage{
\method{formula}{gsl_nls}(x, ...)
}
\arguments{
\item{x}{An object inheriting from class \code{"gsl_nls"}.}

\item{...}{At present no optional arguments are used.}
}
\value{
If the object inherits from class \code{"nls"} returns the fitted model as a \link{formula} similar
to \code{\link[stats]{formula}}. Otherwise returns the fitted model as a \link{function}.
}
\description{
Returns the model formula from a fitted \code{"gsl_nls"} object.
}
\examples{
## data
set.seed(1)
x <- 1:10
y <- 1 + 0.5 * (1:10) + rnorm(10, sd = 0.1)
## model
obj <- gsl_nls(fn = y ~ a + b * x, data = data.frame(x = x, y = y), start = c(a = 0, b = 1))
formula(obj)
}
\seealso{
\code{\link[stats]{formula}}
}
